/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class TropicraftRenderUtils {
    private static Map<String, ResourceLocation> resLocMap = new HashMap<String, ResourceLocation>();
    private static long elapsedTicks;

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> TropicraftRenderUtils.getResLoc(path));
    }

    private static ResourceLocation getResLoc(String path) {
        return new ResourceLocation("tropicraft", path);
    }

    public static ResourceLocation getTextureArmor(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/models/armor/%s.png", path));
    }

    public static ResourceLocation getTextureBlock(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/blocks/%s.png", path));
    }

    public static ResourceLocation getTextureEntity(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/entity/%s.png", path));
    }

    public static ResourceLocation getTextureGui(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/gui/%s.png", path));
    }

    public static ResourceLocation getTextureTE(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/blocks/te/%s.png", path));
    }

    public static ResourceLocation bindTextureArmor(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureArmor(path));
    }

    public static ResourceLocation bindTextureEntity(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureEntity(path));
    }

    public static ResourceLocation bindTextureGui(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureGui(path));
    }

    public static ResourceLocation bindTextureTE(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureTE(path));
    }

    public static ResourceLocation bindTextureBlock(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureBlock(path));
    }

    public static ResourceLocation bindTexture(ResourceLocation resource) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        return resource;
    }

    public static void renderItem(ItemStack stack, float scale) {
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            if (!Minecraft.func_71410_x().func_175599_af().func_175050_a(stack) || stack.func_77973_b() instanceof ItemSkull) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GlStateManager.func_179123_a();
            RenderHelper.func_74519_b();
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    public static String translateGUI(String word) {
        return I18n.func_135052_a((String)String.format("gui.tropicraft.%s", word), (Object[])new Object[0]);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++elapsedTicks;
        }
    }

    public static long getElapsedTicks() {
        return elapsedTicks;
    }
}

