/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.tileentity;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.common.block.BlockSeaweed;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class TileEntitySeaweedRenderer
extends FastTESR<BlockSeaweed.TileSeaweed> {
    private static final TextureAtlasSprite[] SPRITES = new TextureAtlasSprite[8];
    private static final double SWAY_AMOUNT = 0.2;
    private static final double SWAY_PERIOD = 30.0;
    private static final double SWAY_LAG = 7.0;

    public void renderTileEntityFast(BlockSeaweed.TileSeaweed te, double x, double y, double z, float partialTicks, int destroyStage, float alpha, BufferBuilder buf) {
        if (te == null) {
            return;
        }
        buf.func_178969_c(x, y, z);
        Vec3d bot = new Vec3d(0.5, 1.0, 0.5).func_178787_e(te.getOffset());
        Vec3d prevSway = new Vec3d(0.0, 1.0, 0.0);
        for (int i = 0; i < te.getHeight(); ++i) {
            Vec3d sway = this.computeSwayVector(te.getSwayAngle(), i, (double)((float)TropicraftRenderUtils.getElapsedTicks() + partialTicks) + te.getSwayDelay());
            Vec3d top = bot.func_178787_e(sway);
            int texture = i == te.getHeight() - 1 ? SPRITES.length - 1 : (te.getHeight() + i) % (SPRITES.length - 1);
            TextureAtlasSprite sprite = SPRITES[texture];
            this.renderQuad(buf, sprite, bot, top, sway, prevSway, new Vec3d(1.0, 0.0, 1.0));
            this.renderQuad(buf, sprite, bot, top, sway, prevSway, new Vec3d(-1.0, 0.0, 1.0));
            bot = top;
            prevSway = sway;
        }
        buf.func_178969_c(0.0, 0.0, 0.0);
    }

    private Vec3d computeSwayVector(double angle, int height, double time) {
        double sway = Math.sin((time + (double)(height + 1) * 7.0) / 30.0) * 0.2;
        return new Vec3d(0.0, 1.0, 0.0).func_72441_c(Math.sin(angle) * sway, 0.0, Math.cos(angle) * sway).func_72432_b();
    }

    private Vec3d computeCorner(Vec3d center, Vec3d sway, Vec3d angle) {
        return center.func_178787_e(sway.func_72431_c(angle).func_72432_b().func_186678_a(0.5));
    }

    private void renderCorner(BufferBuilder buf, Vec3d center, Vec3d sway, Vec3d angle) {
        Vec3d pos = this.computeCorner(center, sway, angle);
        buf.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).func_181669_b(204, 204, 204, 255);
    }

    private void finishVert(BufferBuilder buf, float u, float v) {
        buf.func_187315_a((double)u, (double)v).func_187314_a(240, 240).func_181675_d();
    }

    private void renderQuad(BufferBuilder buf, TextureAtlasSprite sprite, Vec3d bot, Vec3d top, Vec3d sway, Vec3d prevSway, Vec3d angle) {
        this.renderCorner(buf, bot, prevSway, angle);
        this.finishVert(buf, sprite.func_94209_e(), sprite.func_94210_h());
        this.renderCorner(buf, top, sway, angle);
        this.finishVert(buf, sprite.func_94209_e(), sprite.func_94206_g());
        angle = angle.func_186678_a(-1.0);
        this.renderCorner(buf, top, sway, angle);
        this.finishVert(buf, sprite.func_94212_f(), sprite.func_94206_g());
        this.renderCorner(buf, bot, prevSway, angle);
        this.finishVert(buf, sprite.func_94212_f(), sprite.func_94210_h());
    }

    public boolean isGlobalRenderer(BlockSeaweed.TileSeaweed te) {
        return true;
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        for (int i = 0; i < SPRITES.length; ++i) {
            TileEntitySeaweedRenderer.SPRITES[i] = event.getMap().func_174942_a(new ResourceLocation("tropicraft", "blocks/seaweed_section_" + i));
        }
    }
}

