/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockReed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.tropicraft.core.registry.BlockRegistry;

public class BlockBambooShoot
extends BlockReed
implements IPlantable {
    protected static final AxisAlignedBB BAMBOO_SHOOT_AABB = new AxisAlignedBB(0.275, 0.0, 0.275, 0.725, 1.0, 0.725);

    public BlockBambooShoot() {
        this.func_149711_c(1.0f);
        this.func_149752_b(4.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149647_a(null);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block.canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this)) {
            return true;
        }
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        Block idBelow = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block idAdjacentX1 = world.func_180495_p(new BlockPos(i - 1, j - 1, k)).func_177230_c();
        Block idAdjacentX2 = world.func_180495_p(new BlockPos(i + 1, j - 1, k)).func_177230_c();
        Block idAdjacentZ1 = world.func_180495_p(new BlockPos(i, j - 1, k - 1)).func_177230_c();
        Block idAdjacentZ2 = world.func_180495_p(new BlockPos(i, j - 1, k + 1)).func_177230_c();
        if (idBelow == BlockRegistry.bambooShoot) {
            return true;
        }
        if (idBelow != Blocks.field_150349_c && idBelow != Blocks.field_150346_d && idBelow != Blocks.field_150354_m) {
            return false;
        }
        if (idAdjacentX1 == Blocks.field_150346_d || idAdjacentX1 == Blocks.field_150349_c || idAdjacentX1 == Blocks.field_150354_m) {
            return true;
        }
        if (idAdjacentX2 == Blocks.field_150346_d || idAdjacentX2 == Blocks.field_150349_c || idAdjacentX2 == Blocks.field_150354_m) {
            return true;
        }
        if (idAdjacentZ1 == Blocks.field_150346_d || idAdjacentZ1 == Blocks.field_150349_c || idAdjacentZ1 == Blocks.field_150354_m) {
            return true;
        }
        return idAdjacentZ2 == Blocks.field_150349_c;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BAMBOO_SHOOT_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BAMBOO_SHOOT_AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == BlockRegistry.bambooShoot || this.func_176353_e(worldIn, pos, state)) && worldIn.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)state.func_177229_b((IProperty)field_176355_a);
                if (j == 15) {
                    worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176355_a, (Comparable)Integer.valueOf(0)), 4);
                } else {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176355_a, (Comparable)Integer.valueOf(j + 1)), 4);
                }
            }
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)BlockRegistry.bambooShoot);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockRegistry.bambooShoot);
    }
}

