/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.tropicraft.core.common.block.BlockTropicraftEnumVariants;
import net.tropicraft.core.common.enums.TropicraftBongos;
import net.tropicraft.core.registry.BlockRegistry;

@Mod.EventBusSubscriber
public class BlockBongoDrum
extends BlockTropicraftEnumVariants<TropicraftBongos> {
    public static final float SMALL_DRUM_SIZE = 0.5f;
    public static final float MEDIUM_DRUM_SIZE = 0.6f;
    public static final float BIG_DRUM_SIZE = 0.7f;
    public static final float SMALL_DRUM_OFFSET = 0.25f;
    public static final float MEDIUM_DRUM_OFFSET = 0.19999999f;
    public static final float BIG_DRUM_OFFSET = 0.15f;
    public static final float DRUM_HEIGHT = 1.0f;
    protected final AxisAlignedBB BONGO_SMALL_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    protected final AxisAlignedBB BONGO_MEDIUM_AABB = new AxisAlignedBB(0.19999998807907104, 0.0, 0.19999998807907104, (double)0.8f, 1.0, (double)0.8f);
    protected final AxisAlignedBB BONGO_LARGE_AABB = new AxisAlignedBB((double)0.15f, 0.0, (double)0.15f, (double)0.85f, 1.0, (double)0.85f);

    public BlockBongoDrum() {
        super(Material.field_151594_q, TropicraftBongos.class);
        this.func_149711_c(1.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((TropicraftBongos)this.getVariant(state)) {
            case LARGE: {
                return this.BONGO_LARGE_AABB;
            }
            case MEDIUM: {
                return this.BONGO_MEDIUM_AABB;
            }
        }
        return this.BONGO_SMALL_AABB;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (side != EnumFacing.UP) {
            return false;
        }
        this.playBongoSound(world, playerIn, pos, state);
        return true;
    }

    @SubscribeEvent
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(event.getPos());
        if (state.func_177230_c() == BlockRegistry.bongo && event.getFace() == EnumFacing.UP) {
            ((BlockBongoDrum)BlockRegistry.bongo).playBongoSound(world, event.getEntityPlayer(), event.getPos(), state);
        }
    }

    public void playBongoSound(World world, EntityPlayer entity, BlockPos pos, IBlockState state) {
        TropicraftBongos bongo = (TropicraftBongos)this.getVariant(state);
        world.func_184148_a(entity, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), bongo.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.FENCE;
    }
}

