/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.block.ITropicraftBlock;
import net.tropicraft.core.common.enums.TropicraftFruitLeaves;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class BlockFruitLeaves
extends BlockLeaves
implements ITropicraftBlock {
    public static final PropertyEnum<TropicraftFruitLeaves> VARIANT = PropertyEnum.func_177709_a((String)"variant", TropicraftFruitLeaves.class);

    public BlockFruitLeaves() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false)).func_177226_a(VARIANT, (Comparable)((Object)TropicraftFruitLeaves.GRAPEFRUIT)));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (TropicraftFruitLeaves leaf : TropicraftFruitLeaves.VALUES) {
            list.add((Object)new ItemStack((Block)this, 1, leaf.getMeta()));
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockRegistry.saplings);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)TropicraftFruitLeaves.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((TropicraftFruitLeaves)((Object)state.func_177229_b(VARIANT))).getMeta();
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_149745_a(Random random) {
        return random.nextInt(3) != 0 ? 0 : 1;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = this.func_176232_d(state);
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (rand.nextInt(chance) == 0) {
            int meta = (this.func_176201_c(state) & 3) + 2;
            ret.add(new ItemStack(this.func_180660_a(state, rand, fortune), 1, meta));
        }
        chance = 200;
        if (fortune > 0 && (chance -= 10 << fortune) < 40) {
            chance = 40;
        }
        this.captureDrops(true);
        if (world instanceof World) {
            int treeType = this.func_176201_c(state) & 3;
            if (treeType == 0) {
                ret.add(new ItemStack(ItemRegistry.grapefruit));
            } else if (treeType == 1) {
                ret.add(new ItemStack(ItemRegistry.lemon));
            } else if (treeType == 2) {
                ret.add(new ItemStack(ItemRegistry.lime));
            } else {
                ret.add(new ItemStack(ItemRegistry.orange));
            }
        }
        ret.addAll((Collection<ItemStack>)this.captureDrops(false));
        return ret;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a, VARIANT});
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((TropicraftFruitLeaves)((Object)state.func_177229_b(VARIANT))).func_176610_l();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            int meta = this.func_176201_c(state);
            items.add(new ItemStack((Block)this, 1, meta));
        }
        return items;
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }
}

