/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.tropicraft.core.common.block.ITropicraftBlock;

public class BlockIris
extends BlockBush
implements ITropicraftBlock {
    public static final PropertyEnum<PlantHalf> HALF = PropertyEnum.func_177709_a((String)"half", PlantHalf.class);

    public BlockIris() {
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HALF, (Comparable)((Object)PlantHalf.LOWER)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), this.func_176203_a(stack.func_77960_j()).func_177226_a(HALF, (Comparable)((Object)PlantHalf.UPPER)), 3);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    @Override
    public String getStateName(IBlockState state) {
        return "iris";
    }

    @Override
    public IBlockColor getBlockColor() {
        return null;
    }

    @Override
    public IItemColor getItemColor() {
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)PlantHalf.values()[meta >> 3]));
    }

    public int func_176201_c(IBlockState state) {
        return ((PlantHalf)((Object)state.func_177229_b(HALF))).ordinal() * 8;
    }

    public BlockPos getLowerPos(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return pos;
        }
        return world.func_180495_p(pos).func_177229_b(HALF) == PlantHalf.UPPER ? pos.func_177977_b() : pos;
    }

    public BlockPos getUpperPos(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return pos.func_177984_a();
        }
        return world.func_180495_p(pos).func_177229_b(HALF) == PlantHalf.UPPER ? pos : pos.func_177984_a();
    }

    public IBlockState getStateLower(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(this.getLowerPos(world, pos));
    }

    public IBlockState getStateUpper(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(this.getUpperPos(world, pos));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a(HALF, (Comparable)((Object)PlantHalf.LOWER));
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        return block.canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return super.func_180671_f(worldIn, pos, state);
        }
        if (state.func_177229_b(HALF) == PlantHalf.UPPER) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());
        return iblockstate.func_177230_c() == this && super.func_180671_f(worldIn, pos, iblockstate);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(worldIn, pos, state, player);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(HALF) == PlantHalf.UPPER ? super.func_180660_a(state, rand, fortune) : null;
    }

    public static enum PlantHalf implements IStringSerializable
    {
        LOWER,
        UPPER;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

