/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.ITropicraftBlock;
import net.tropicraft.core.common.enums.TropicraftTallPlants;

public abstract class BlockTallPlant
extends BlockBush
implements ITropicraftBlock {
    protected static final AxisAlignedBB FULL_HEIGHT_AABB = field_185515_b.func_186666_e(1.0);
    public static final PropertyEnum<TropicraftTallPlants> VARIANT = PropertyEnum.func_177709_a((String)"variant", TropicraftTallPlants.class);
    public static final PropertyEnum<PlantHalf> HALF = PropertyEnum.func_177709_a((String)"half", PlantHalf.class);

    public BlockTallPlant() {
        super(Material.field_151585_k);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)TropicraftTallPlants.PINEAPPLE)).func_177226_a(HALF, (Comparable)((Object)PlantHalf.LOWER)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, HALF});
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((TropicraftTallPlants)((Object)state.func_177229_b(VARIANT))).func_176610_l();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)PlantHalf.values()[meta >> 3])).func_177226_a(VARIANT, (Comparable)((Object)TropicraftTallPlants.byMetadata(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((PlantHalf)((Object)state.func_177229_b(HALF))).ordinal() * 8 + ((TropicraftTallPlants)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public BlockPos getLowerPos(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return pos;
        }
        return world.func_180495_p(pos).func_177229_b(HALF) == PlantHalf.UPPER ? pos.func_177977_b() : pos;
    }

    public BlockPos getUpperPos(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return pos.func_177984_a();
        }
        return world.func_180495_p(pos).func_177229_b(HALF) == PlantHalf.UPPER ? pos : pos.func_177984_a();
    }

    public IBlockState getStateLower(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(this.getLowerPos(world, pos));
    }

    public IBlockState getStateUpper(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(this.getUpperPos(world, pos));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a(HALF, (Comparable)((Object)PlantHalf.LOWER));
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(HALF) == PlantHalf.LOWER ? FULL_HEIGHT_AABB : field_185515_b;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(HALF) == PlantHalf.UPPER ? super.func_180660_a(state, rand, fortune) : null;
    }

    public static enum PlantHalf implements IStringSerializable
    {
        LOWER,
        UPPER;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

