/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.block.BlockTropicraft;
import net.tropicraft.core.common.block.ITropicraftBlock;
import net.tropicraft.core.registry.BlockRegistry;

public class BlockTikiTorch
extends BlockTropicraft
implements ITropicraftBlock {
    public static final PropertyEnum<TorchSection> SECTION = PropertyEnum.func_177709_a((String)"section", TorchSection.class);
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB((double)0.4f, 0.0, (double)0.4f, (double)0.6f, 0.999999, (double)0.6f);
    protected static final AxisAlignedBB TOP_AABB = new AxisAlignedBB((double)0.4f, 0.0, (double)0.4f, (double)0.6f, (double)0.6f, (double)0.6f);

    public BlockTikiTorch() {
        super(Material.field_151594_q);
        this.func_149675_a(true);
        this.func_149647_a(null);
        this.field_149784_t = 15;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SECTION, (Comparable)((Object)TorchSection.UPPER)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TorchSection section = (TorchSection)((Object)state.func_177229_b(SECTION));
        if (section == TorchSection.UPPER) {
            return TOP_AABB;
        }
        return BASE_AABB;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        if (!super.func_176196_c(world, pos)) {
            return false;
        }
        PlaceMode mode = this.canPlaceTikiTorchOn(world, pos);
        if (mode == PlaceMode.FULL) {
            return world.func_175623_d(pos.func_177984_a()) && world.func_175623_d(pos.func_177981_b(2));
        }
        return mode == PlaceMode.TOP_ONLY;
    }

    @SideOnly(value=Side.CLIENT)
    public Item getItem(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)BlockRegistry.tikiTorch);
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private PlaceMode canPlaceTikiTorchOn(World world, BlockPos pos) {
        if (Blocks.field_150478_aa.func_176196_c(world, pos)) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockFence || state.func_177230_c() instanceof BlockWall) {
                return PlaceMode.TOP_ONLY;
            }
            return PlaceMode.FULL;
        }
        return PlaceMode.BLOCKED;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177230_c() != this) {
            return null;
        }
        if (state.func_177229_b(SECTION) == TorchSection.LOWER || state.func_177229_b(SECTION) == TorchSection.MIDDLE) {
            return null;
        }
        return Item.func_150898_a((Block)this);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(SECTION, (Comparable)((Object)TorchSection.LOWER));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.onNeighborChangeInternal(worldIn, pos, state);
    }

    protected boolean onNeighborChangeInternal(World world, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(world, pos, state)) {
            return true;
        }
        if (!world.field_72995_K && state.func_177229_b(SECTION) == TorchSection.LOWER && !this.canPlaceAt(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        return false;
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(SECTION) != TorchSection.LOWER || state.func_177230_c() == this && this.canPlaceAt(worldIn, pos)) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TorchSection section = (TorchSection)((Object)state.func_177229_b(SECTION));
        if (section == TorchSection.UPPER) {
            return;
        }
        IBlockState stateBelow = worldIn.func_180495_p(pos.func_177977_b());
        if (stateBelow.func_177230_c() instanceof BlockFence || stateBelow.func_177230_c() instanceof BlockWall) {
            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a(SECTION, (Comparable)((Object)TorchSection.UPPER)), 2);
        } else {
            worldIn.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(SECTION, (Comparable)((Object)TorchSection.MIDDLE)), 2);
            worldIn.func_180501_a(pos.func_177981_b(2), this.func_176223_P().func_177226_a(SECTION, (Comparable)((Object)TorchSection.UPPER)), 2);
        }
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos) {
        return this.canPlaceTikiTorchOn(worldIn, pos.func_177977_b()) != PlaceMode.BLOCKED;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(world, pos, state, player);
        if (!world.field_72995_K) {
            switch ((TorchSection)((Object)state.func_177229_b(SECTION))) {
                case MIDDLE: {
                    this.func_176226_b(world, pos, world.func_180495_p(pos.func_177984_a()), 0);
                    break;
                }
                case LOWER: {
                    this.func_176226_b(world, pos, world.func_180495_p(pos.func_177981_b(2)), 0);
                    break;
                }
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        if (!world.field_72995_K) {
            TorchSection section = (TorchSection)((Object)state.func_177229_b(SECTION));
            if (section == TorchSection.LOWER) {
                if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                    world.func_175698_g(pos.func_177984_a());
                }
                if (world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this) {
                    world.func_175698_g(pos.func_177981_b(2));
                }
            } else if (section == TorchSection.MIDDLE) {
                if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                    world.func_175698_g(pos.func_177977_b());
                }
                if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                    world.func_175698_g(pos.func_177984_a());
                }
            } else {
                if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                    world.func_175698_g(pos.func_177977_b());
                }
                if (world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == this) {
                    world.func_175698_g(pos.func_177979_c(2));
                }
            }
        }
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        this.func_176206_d(world, pos, world.func_180495_p(pos));
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        boolean isTop;
        boolean bl = isTop = (TorchSection)((Object)state.func_177229_b(SECTION)) == TorchSection.UPPER;
        if (isTop) {
            double d = (float)pos.func_177958_n() + 0.5f;
            double d1 = (float)pos.func_177956_o() + 0.7f;
            double d2 = (float)pos.func_177952_p() + 0.5f;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, d, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean isTop;
        boolean bl = isTop = (TorchSection)((Object)state.func_177229_b(SECTION)) == TorchSection.UPPER;
        if (isTop) {
            return super.getLightValue(state, world, pos);
        }
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SECTION});
    }

    @Override
    public String getStateName(IBlockState state) {
        return "tiki_torch_" + ((TorchSection)((Object)state.func_177229_b(SECTION))).func_176610_l();
    }

    @Override
    public IBlockColor getBlockColor() {
        return null;
    }

    @Override
    public IItemColor getItemColor() {
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        TorchSection section = null;
        switch (meta) {
            case 0: {
                section = TorchSection.UPPER;
                break;
            }
            case 1: {
                section = TorchSection.MIDDLE;
                break;
            }
            case 2: {
                section = TorchSection.LOWER;
                break;
            }
            default: {
                section = TorchSection.UPPER;
            }
        }
        return this.func_176223_P().func_177226_a(SECTION, (Comparable)((Object)section));
    }

    public int func_176201_c(IBlockState state) {
        return ((TorchSection)((Object)state.func_177229_b(SECTION))).ordinal();
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.getAiPathNodeType(state, world, pos);
    }

    private static enum PlaceMode {
        FULL,
        TOP_ONLY,
        BLOCKED;

    }

    public static enum TorchSection implements IStringSerializable
    {
        UPPER,
        MIDDLE,
        LOWER;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

