/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.HashSet;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;
import org.apache.commons.lang3.ArrayUtils;

public class BlockTropicraftFence
extends BlockFence {
    public static final IProperty<WaterState> WATER = PropertyEnum.func_177709_a((String)"water", WaterState.class);
    private final BlockFenceGate gate;

    public BlockTropicraftFence(BlockFenceGate fenceGate, Material material, MapColor mapColor) {
        super(material, mapColor);
        this.field_149783_u = true;
        this.func_180632_j(this.func_176223_P().func_177226_a(WATER, (Comparable)((Object)WaterState.NONE)));
        this.gate = fenceGate;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        Object[] superProps = super.func_180661_e().func_177623_d().toArray(new IProperty[4]);
        return new BlockStateContainer((Block)this, (IProperty[])ArrayUtils.addAll((Object[])superProps, (Object[])new IProperty[]{WATER, BlockFluidBase.LEVEL}));
    }

    public int func_176201_c(IBlockState state) {
        return ((WaterState)((Object)state.func_177229_b(WATER))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(WATER, (Comparable)((Object)WaterState.values()[meta % WaterState.values().length]));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.updateWaterState(state, worldIn, pos);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getWaterState(super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand), world, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.updateWaterState(state, worldIn, pos);
    }

    protected final IBlockState getWaterState(IBlockState state, World world, BlockPos pos) {
        WaterState water = WaterState.NONE;
        IBlockState up = world.func_180495_p(pos.func_177984_a());
        HashSet<IBlockState> neighbors = new HashSet<IBlockState>();
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            neighbors.add(world.func_180495_p(pos.func_177972_a(dir)));
        }
        if (neighbors.stream().anyMatch(s -> s.func_177230_c() == this && s.func_177229_b(WATER) != WaterState.NONE || s.func_177230_c() == BlockRegistry.tropicsWater && (Integer)s.func_177229_b((IProperty)BlockFluidBase.LEVEL) == 0)) {
            water = WaterState.UNDER;
        }
        if (neighbors.stream().allMatch(s -> s.func_177230_c() != BlockRegistry.tropicsWater || (Integer)s.func_177229_b((IProperty)BlockFluidBase.LEVEL) != 0)) {
            water = WaterState.NONE;
        }
        if (water == WaterState.UNDER && up.func_177230_c() != BlockRegistry.tropicsWater && (up.func_177230_c() != this || up.func_177229_b(WATER) == WaterState.NONE)) {
            water = WaterState.SURFACE;
        }
        return state.func_177226_a(WATER, (Comparable)((Object)water)).func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(water == WaterState.NONE ? 15 : 0));
    }

    protected final void updateWaterState(IBlockState state, World world, BlockPos pos) {
        IBlockState newState = this.getWaterState(state, world, pos);
        if (state.func_177229_b(WATER) != newState.func_177229_b(WATER)) {
            world.func_175656_a(pos, newState);
        }
    }

    @Nonnull
    public Material func_149688_o(IBlockState state) {
        return state.func_177229_b(WATER) == WaterState.NONE ? super.func_149688_o(state) : Material.field_151586_h;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @Deprecated
    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.gate.func_176195_g(blockState, worldIn, pos);
    }

    public boolean func_176524_e(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state = TCGenUtils.getBlockState(world, pos);
        Block block = state.func_177230_c();
        if (block != this && block != BlockRegistry.bambooFenceGate && block != BlockRegistry.palmFenceGate) {
            return block == Blocks.field_180401_cv ? false : (!(block instanceof BlockFence && state.func_185904_a() == this.field_149764_J || block instanceof BlockFenceGate) ? (state.func_185904_a().func_76218_k() && state.func_185917_h() ? state.func_185904_a() != Material.field_151572_C : false) : true);
        }
        return true;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public static enum WaterState implements IStringSerializable
    {
        UNDER,
        SURFACE,
        NONE;


        @Nonnull
        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

