/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.block.BlockTropicraft;
import net.tropicraft.core.common.block.tileentity.TileEntityFactory;
import net.tropicraft.core.common.block.tileentity.TileEntityTropicraftFlowerPot;
import net.tropicraft.core.common.enums.TropicraftFlowerType;
import net.tropicraft.core.common.enums.TropicraftFlowers;
import net.tropicraft.core.common.enums.TropicraftSaplings;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class BlockTropicraftFlowerPot
extends BlockTropicraft
implements ITileEntityProvider {
    protected static final AxisAlignedBB FLOWER_POT_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);
    public static final PropertyEnum<TropicraftFlowerType> CONTENTS = PropertyEnum.func_177709_a((String)"contents", TropicraftFlowerType.class);

    public BlockTropicraftFlowerPot() {
        super(Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CONTENTS, (Comparable)((Object)TropicraftFlowerType.EMPTY)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLOWER_POT_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemBlock) {
            TileEntityTropicraftFlowerPot flowerPotTE = this.getTileEntity(worldIn, pos);
            if (flowerPotTE == null) {
                return false;
            }
            if (flowerPotTE.getFlowerPotItem() != null) {
                return false;
            }
            Block block = Block.func_149634_a((Item)heldItem.func_77973_b());
            if (!this.canContain(block, heldItem.func_77960_j())) {
                return false;
            }
            flowerPotTE.setFlowerPotData(heldItem.func_77973_b(), heldItem.func_77960_j());
            flowerPotTE.func_70296_d();
            worldIn.func_184138_a(pos, state, state, 3);
            playerIn.func_71029_a(StatList.field_188088_V);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    private boolean canContain(@Nullable Block block, int meta) {
        return block == BlockRegistry.flowers || block == BlockRegistry.iris || block == BlockRegistry.pineapple || block == BlockRegistry.saplings;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack itemstack;
        TileEntityTropicraftFlowerPot tileentityflowerpot = this.getTileEntity(worldIn, pos);
        if (tileentityflowerpot != null && !(itemstack = tileentityflowerpot.getFlowerItemStack()).func_190926_b()) {
            return itemstack;
        }
        return new ItemStack(Items.field_151162_bE);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.func_180495_p(pos.func_177977_b()).func_185896_q();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.func_180495_p(pos.func_177977_b()).func_185896_q()) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityTropicraftFlowerPot tileentityflowerpot;
        super.func_176208_a(worldIn, pos, state, player);
        if (player.field_71075_bZ.field_75098_d && (tileentityflowerpot = this.getTileEntity(worldIn, pos)) != null) {
            tileentityflowerpot.setFlowerPotData(null, 0);
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemRegistry.flowerPot;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONTENTS});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityTropicraftFlowerPot tileentityflowerpot;
        Item item;
        TropicraftFlowerType flowerType = TropicraftFlowerType.EMPTY;
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityTropicraftFlowerPot && (item = (tileentityflowerpot = (TileEntityTropicraftFlowerPot)tileentity).getFlowerPotItem()) instanceof ItemBlock) {
            int i = tileentityflowerpot.getFlowerPotData();
            Block block = Block.func_149634_a((Item)item);
            if (block == BlockRegistry.saplings) {
                switch (TropicraftSaplings.byMetadata(i)) {
                    case PALM: {
                        flowerType = TropicraftFlowerType.PALM_SAPLING;
                        break;
                    }
                    case MAHOGANY: {
                        flowerType = TropicraftFlowerType.MAHOGANY_SAPLING;
                        break;
                    }
                    case GRAPEFRUIT: {
                        flowerType = TropicraftFlowerType.GRAPEFRUIT_SAPLING;
                        break;
                    }
                    case LEMON: {
                        flowerType = TropicraftFlowerType.LEMON_SAPLING;
                        break;
                    }
                    case LIME: {
                        flowerType = TropicraftFlowerType.LIME_SAPLING;
                        break;
                    }
                    case ORANGE: {
                        flowerType = TropicraftFlowerType.ORANGE_SAPLING;
                        break;
                    }
                    default: {
                        flowerType = TropicraftFlowerType.EMPTY;
                        break;
                    }
                }
            } else if (block == BlockRegistry.flowers) {
                switch (TropicraftFlowers.VALUES[i]) {
                    case COMMELINA_DIFFUSA: {
                        flowerType = TropicraftFlowerType.COMMELINA_DIFFUSA;
                        break;
                    }
                    case CROCOSMIA: {
                        flowerType = TropicraftFlowerType.CROCOSMIA;
                        break;
                    }
                    case ORCHID: {
                        flowerType = TropicraftFlowerType.ORCHID;
                        break;
                    }
                    case CANNA: {
                        flowerType = TropicraftFlowerType.CANNA;
                        break;
                    }
                    case ANEMONE: {
                        flowerType = TropicraftFlowerType.ANEMONE;
                        break;
                    }
                    case ORANGE_ANTHURIUM: {
                        flowerType = TropicraftFlowerType.ORANGE_ANTHURIUM;
                        break;
                    }
                    case RED_ANTHURIUM: {
                        flowerType = TropicraftFlowerType.RED_ANTHURIUM;
                        break;
                    }
                    case MAGIC_MUSHROOM: {
                        flowerType = TropicraftFlowerType.MAGIC_MUSHROOM;
                        break;
                    }
                    case PATHOS: {
                        flowerType = TropicraftFlowerType.PATHOS;
                        break;
                    }
                    case ACAI_VINE: {
                        flowerType = TropicraftFlowerType.ACAI_VINE;
                        break;
                    }
                    case CROTON: {
                        flowerType = TropicraftFlowerType.CROTON;
                        break;
                    }
                    case DRACAENA: {
                        flowerType = TropicraftFlowerType.DRACAENA;
                        break;
                    }
                    case FERN: {
                        flowerType = TropicraftFlowerType.FERN;
                        break;
                    }
                    case FOLIAGE: {
                        flowerType = TropicraftFlowerType.FOILAGE;
                        break;
                    }
                    case BROMELIAD: {
                        flowerType = TropicraftFlowerType.BROMELIAD;
                        break;
                    }
                    default: {
                        flowerType = TropicraftFlowerType.EMPTY;
                    }
                }
            }
        }
        return state.func_177226_a(CONTENTS, (Comparable)((Object)flowerType));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return TileEntityFactory.getFlowerPotTE();
    }

    @Nullable
    private TileEntityTropicraftFlowerPot getTileEntity(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof TileEntityTropicraftFlowerPot ? (TileEntityTropicraftFlowerPot)tileentity : null;
    }
}

