/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.block.BlockTropicraftFence;
import net.tropicraft.core.common.block.ITropicraftBlock;
import net.tropicraft.core.common.enums.TropicraftSands;
import net.tropicraft.core.registry.BlockRegistry;

public class BlockTropicraftSands
extends BlockFalling
implements ITropicraftBlock {
    public static final PropertyEnum<TropicraftSands> VARIANT = PropertyEnum.func_177709_a((String)"variant", TropicraftSands.class);
    public static final PropertyBool UNDERWATER = PropertyBool.func_177716_a((String)"underwater");

    public BlockTropicraftSands() {
        super(Material.field_151595_p);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185855_h);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)TropicraftSands.PURIFIED)).func_177226_a((IProperty)UNDERWATER, (Comparable)Boolean.valueOf(false)));
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177229_b(VARIANT) != TropicraftSands.VOLCANIC) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
            if (stack.func_190926_b()) {
                player.func_70097_a(DamageSource.field_76371_c, 0.5f);
            }
        } else {
            entity.func_70097_a(DamageSource.field_76371_c, 0.5f);
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return super.canSustainPlant(state, world, pos, direction, plantable) || plantable.getPlantType(world, pos) == EnumPlantType.Beach;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < TropicraftSands.VALUES.length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, UNDERWATER});
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((TropicraftSands)((Object)state.func_177229_b(VARIANT))).func_176610_l();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)TropicraftSands.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((TropicraftSands)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState ret = super.func_176221_a(state, worldIn, pos);
        IBlockState above = worldIn.func_180495_p(pos.func_177984_a());
        if (pos.func_177956_o() < 64 && (above.func_177230_c() == BlockRegistry.tropicsWater || above.func_177230_c() == BlockRegistry.coral || above.func_177230_c() instanceof BlockTropicraftFence && above.func_177229_b(BlockTropicraftFence.WATER) != BlockTropicraftFence.WaterState.NONE)) {
            ret = ret.func_177226_a((IProperty)UNDERWATER, (Comparable)Boolean.valueOf(true));
        }
        return ret;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }
}

