/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.block.ITropicraftBlock;
import net.tropicraft.core.common.enums.TropicraftSaplings;
import net.tropicraft.core.common.worldgen.TCGenBase;
import net.tropicraft.core.common.worldgen.WorldGenCurvedPalms;
import net.tropicraft.core.common.worldgen.WorldGenFruitTrees;
import net.tropicraft.core.common.worldgen.WorldGenLargePalmTrees;
import net.tropicraft.core.common.worldgen.WorldGenNormalPalms;
import net.tropicraft.core.common.worldgen.WorldGenTallTree;
import net.tropicraft.core.common.worldgen.WorldGenTualang;
import net.tropicraft.core.common.worldgen.WorldGenUpTree;

public class BlockTropicsSapling
extends BlockBush
implements ITropicraftBlock,
IGrowable {
    public static final PropertyEnum<TropicraftSaplings> VARIANT = PropertyEnum.func_177709_a((String)"variant", TropicraftSaplings.class);
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    public static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockTropicsSapling() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)TropicraftSaplings.PALM)).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta >> 3)).func_177226_a(VARIANT, (Comparable)((Object)TropicraftSaplings.byMetadata(meta & 7)));
    }

    public int func_180651_a(IBlockState state) {
        return ((TropicraftSaplings)((Object)state.func_177229_b(VARIANT))).getMetadata() & 7;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((TropicraftSaplings)((Object)state.func_177229_b(VARIANT))).getMetadata();
        return i |= (Integer)state.func_177229_b((IProperty)STAGE) << 3;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE, VARIANT});
    }

    protected boolean func_185514_i(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151595_p;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (world.func_175699_k(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(world, rand, pos, state);
            }
        }
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((TropicraftSaplings)((Object)state.func_177229_b(VARIANT))).func_176610_l();
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        WorldGenerator gen;
        TCGenBase.blockGenNotifyFlag = 3;
        TropicraftSaplings variant = (TropicraftSaplings)((Object)state.func_177229_b(VARIANT));
        switch (variant) {
            case PALM: {
                int b = rand.nextInt(3);
                if (b == 0) {
                    gen = new WorldGenLargePalmTrees(worldIn, rand);
                    break;
                }
                if (b == 1) {
                    gen = new WorldGenCurvedPalms(worldIn, rand);
                    break;
                }
                if (b == 2) {
                    gen = new WorldGenNormalPalms(worldIn, rand);
                    break;
                }
                gen = null;
                break;
            }
            case MAHOGANY: {
                gen = this.randomRainforestTreeGen(worldIn);
                break;
            }
            default: {
                gen = new WorldGenFruitTrees(worldIn, rand, variant.getMeta() - 2);
            }
        }
        if (gen != null) {
            worldIn.func_175698_g(pos);
            if (!gen.func_180709_b(worldIn, rand, pos)) {
                worldIn.func_180501_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)variant)), 3);
            }
        }
        TCGenBase.blockGenNotifyFlag = 2;
    }

    private WorldGenerator randomRainforestTreeGen(World world) {
        Random rand = new Random();
        int type = rand.nextInt(4);
        switch (type) {
            case 0: {
                return new WorldGenTallTree(world, rand);
            }
            case 1: {
                return new WorldGenUpTree(world, rand);
            }
            case 3: {
                return new WorldGenTualang(world, rand, 18, 9);
            }
        }
        return new WorldGenTualang(world, rand, 25, 10);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (TropicraftSaplings sapling : TropicraftSaplings.VALUES) {
            list.add((Object)new ItemStack((Block)this, 1, sapling.getMetadata()));
        }
    }

    @Override
    public IBlockColor getBlockColor() {
        return null;
    }

    @Override
    public IItemColor getItemColor() {
        return null;
    }
}

