/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.tropicraft.core.common.block.scuba.BlockAirCompressor;
import net.tropicraft.core.common.block.tileentity.IMachineTile;
import net.tropicraft.core.common.block.tileentity.message.MessageAirCompressorInventory;
import net.tropicraft.core.common.item.scuba.ItemScubaTank;
import net.tropicraft.core.common.item.scuba.ScubaCapabilities;
import net.tropicraft.core.common.item.scuba.api.IScubaTank;
import net.tropicraft.core.common.network.TCPacketHandler;

public class TileEntityAirCompressor
extends TileEntity
implements ITickable,
IMachineTile {
    private boolean compressing;
    private int ticks;
    private static final float fillRate = 0.1f;
    @Nonnull
    private ItemStack stack = ItemStack.field_190927_a;
    private IScubaTank tank;

    public void func_145839_a(@Nonnull NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.compressing = nbt.func_74767_n("Compressing");
        this.ticks = nbt.func_74762_e("Ticks");
        if (nbt.func_74764_b("Tank")) {
            this.setTank(new ItemStack(nbt.func_74775_l("Tank")));
        } else {
            this.setTank(ItemStack.field_190927_a);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Compressing", this.compressing);
        nbt.func_74768_a("Ticks", this.ticks);
        NBTTagCompound var4 = new NBTTagCompound();
        this.stack.func_77955_b(var4);
        nbt.func_74782_a("Tank", (NBTBase)var4);
        return nbt;
    }

    public void setTank(@Nonnull ItemStack tankItemStack) {
        this.stack = tankItemStack;
        this.tank = this.stack.func_190926_b() ? null : (IScubaTank)this.stack.getCapability(ScubaCapabilities.getTankCapability(), null);
    }

    @Nonnull
    public ItemStack getTankStack() {
        return this.stack;
    }

    public IScubaTank getTank() {
        return this.tank;
    }

    public void func_73660_a() {
        if (this.tank == null) {
            return;
        }
        float airContained = this.tank.getPressure();
        if (this.compressing && airContained < this.tank.getAirType().getMaxCapacity()) {
            if (airContained + 0.1f >= this.tank.getAirType().getMaxCapacity()) {
                this.tank.setPressure(this.tank.getAirType().getMaxCapacity());
                ++this.ticks;
                this.finishCompressing();
            } else {
                this.tank.setPressure(airContained + 0.1f);
                ++this.ticks;
            }
        }
    }

    public NBTTagCompound getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public boolean addTank(ItemStack stack) {
        if (this.tank == null && stack.func_77973_b() instanceof ItemScubaTank) {
            this.setTank(stack);
            this.compressing = true;
            this.syncInventory();
            return true;
        }
        return false;
    }

    public void ejectTank() {
        if (!this.stack.func_190926_b() && !this.field_145850_b.field_72995_K) {
            EntityItem tankItem = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), this.stack);
            this.field_145850_b.func_72838_d((Entity)tankItem);
        }
        this.setTank(ItemStack.field_190927_a);
        this.syncInventory();
        this.ticks = 0;
        this.compressing = false;
    }

    public boolean isDoneCompressing() {
        return this.ticks > 0 && !this.compressing;
    }

    public float getTickRatio(float partialTicks) {
        if (this.tank != null) {
            return ((float)this.ticks + partialTicks) / (this.tank.getAirType().getMaxCapacity() * 0.1f);
        }
        return 0.0f;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void startCompressing() {
        this.compressing = true;
        this.syncInventory();
    }

    public void finishCompressing() {
        this.compressing = false;
        this.syncInventory();
    }

    public float getBreatheProgress(float partialTicks) {
        return (float)(((double)(this.getProgress(partialTicks) * 10.0f) * Math.PI + Math.PI) % (Math.PI * 2));
    }

    @Override
    public boolean isActive() {
        return !this.getTankStack().func_190926_b();
    }

    @Override
    public float getProgress(float partialTicks) {
        return this.getTickRatio(partialTicks);
    }

    @Override
    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b(BlockAirCompressor.FACING);
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    protected void syncInventory() {
        if (!this.field_145850_b.field_72995_K) {
            TCPacketHandler.INSTANCE.sendToDimension(new MessageAirCompressorInventory(this), this.func_145831_w().field_73011_w.getDimension());
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbttagcompound = this.func_189515_b(new NBTTagCompound());
        return nbttagcompound;
    }
}

