/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.BlockDrinkMixer;
import net.tropicraft.core.common.block.tileentity.IMachineTile;
import net.tropicraft.core.common.block.tileentity.message.MessageMixerInventory;
import net.tropicraft.core.common.block.tileentity.message.MessageMixerStart;
import net.tropicraft.core.common.drinks.Ingredient;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.item.ItemCocktail;
import net.tropicraft.core.common.network.TCPacketHandler;
import net.tropicraft.core.registry.DrinkMixerRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class TileEntityDrinkMixer
extends TileEntity
implements ITickable,
IMachineTile {
    public int ticks;
    public static final int TICKS_TO_MIX = 80;
    @Nonnull
    public NonNullList<ItemStack> ingredients;
    public boolean mixing = false;
    @Nonnull
    public ItemStack result = ItemStack.field_190927_a;
    public static final int MAX_NUM_INGREDIENTS = 3;

    public TileEntityDrinkMixer() {
        this.ingredients = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    }

    public void func_145839_a(@Nonnull NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ticks = nbt.func_74762_e("MixTicks");
        this.mixing = nbt.func_74767_n("Mixing");
        for (int i = 0; i < 3; ++i) {
            if (!nbt.func_74764_b("Ingredient" + i)) continue;
            this.ingredients.set(i, (Object)new ItemStack(nbt.func_74775_l("Ingredient" + i)));
        }
        if (nbt.func_74764_b("Result")) {
            this.result = new ItemStack(nbt.func_74775_l("Result"));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("MixTicks", this.ticks);
        nbt.func_74757_a("Mixing", this.mixing);
        for (int i = 0; i < 3; ++i) {
            NBTTagCompound var4 = new NBTTagCompound();
            ((ItemStack)this.ingredients.get(i)).func_77955_b(var4);
            nbt.func_74782_a("Ingredient" + i, (NBTBase)var4);
        }
        NBTTagCompound var4 = new NBTTagCompound();
        this.result.func_77955_b(var4);
        nbt.func_74782_a("Result", (NBTBase)var4);
        return nbt;
    }

    public void func_73660_a() {
        if (this.ticks < 80 && this.mixing) {
            ++this.ticks;
            if (this.ticks == 80) {
                this.finishMixing();
            }
        }
    }

    public boolean isDoneMixing() {
        return !this.result.func_190926_b();
    }

    public NonNullList<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public static Ingredient findMatchingIngredient(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (Ingredient ingredient : Ingredient.ingredientsList) {
            if (ingredient == null || !ItemStack.func_77989_b((ItemStack)ingredient.getIngredient(), (ItemStack)stack)) continue;
            return ingredient;
        }
        return null;
    }

    public static List<Ingredient> listIngredients(@Nonnull ItemStack stack) {
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        if (stack.func_77973_b() == ItemRegistry.cocktail) {
            for (Ingredient ingredient : ItemCocktail.getIngredients(stack)) {
                is.add(ingredient);
            }
        } else {
            Ingredient i = TileEntityDrinkMixer.findMatchingIngredient(stack);
            if (i != null) {
                is.add(i);
            }
        }
        return is;
    }

    public void startMixing() {
        this.ticks = 0;
        this.mixing = true;
        if (!this.func_145831_w().field_72995_K) {
            TCPacketHandler.INSTANCE.sendToDimension(new MessageMixerStart(this), this.func_145831_w().field_73011_w.getDimension());
        }
    }

    private void dropItem(@Nonnull ItemStack stack, @Nullable EntityPlayer at) {
        if (at == null) {
            BlockPos pos = this.func_174877_v().func_177972_a((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b(BlockDrinkMixer.FACING));
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        } else {
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)at.field_70165_t, (double)at.field_70163_u, (double)at.field_70161_v, (ItemStack)stack);
        }
    }

    public void emptyMixer(@Nullable EntityPlayer at) {
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.ingredients.get(i)).func_190926_b()) continue;
            this.dropItem((ItemStack)this.ingredients.get(i), at);
            this.ingredients.set(i, (Object)ItemStack.field_190927_a);
        }
        this.ticks = 80;
        this.mixing = false;
        this.syncInventory();
    }

    public void retrieveResult(@Nullable EntityPlayer at) {
        if (this.result.func_190926_b()) {
            return;
        }
        this.dropItem(this.result, at);
        for (int i = 0; i < 3; ++i) {
            ItemStack container;
            if (((ItemStack)this.ingredients.get(i)).func_190926_b() || (container = ((ItemStack)this.ingredients.get(i)).func_77973_b().getContainerItem((ItemStack)this.ingredients.get(i))).func_190926_b()) continue;
            this.dropItem(container, at);
        }
        this.ingredients.clear();
        this.result = ItemStack.field_190927_a;
        this.syncInventory();
    }

    public void finishMixing() {
        this.result = this.getResult(this.getIngredients());
        this.mixing = false;
        this.ticks = 0;
        this.syncInventory();
    }

    public boolean addToMixer(@Nonnull ItemStack ingredient) {
        if (((ItemStack)this.ingredients.get(0)).func_190926_b()) {
            Ingredient i;
            if (ingredient.func_77973_b() != ItemRegistry.cocktail && (i = TileEntityDrinkMixer.findMatchingIngredient(ingredient)) == null) {
                return false;
            }
            this.ingredients.set(0, (Object)ingredient);
            this.syncInventory();
            return true;
        }
        if (((ItemStack)this.ingredients.get(1)).func_190926_b()) {
            if (ingredient.func_77973_b() == ItemRegistry.cocktail) {
                return false;
            }
            Ingredient ing0 = TileEntityDrinkMixer.findMatchingIngredient((ItemStack)this.ingredients.get(0));
            Ingredient i = TileEntityDrinkMixer.findMatchingIngredient(ingredient);
            if (i == null || ing0.id == i.id) {
                return false;
            }
            this.ingredients.set(1, (Object)ingredient);
            this.syncInventory();
            return true;
        }
        if (((ItemStack)this.ingredients.get(2)).func_190926_b()) {
            if (ingredient.func_77973_b() == ItemRegistry.cocktail) {
                return false;
            }
            Ingredient ing0 = TileEntityDrinkMixer.findMatchingIngredient((ItemStack)this.ingredients.get(0));
            Ingredient ing1 = TileEntityDrinkMixer.findMatchingIngredient((ItemStack)this.ingredients.get(1));
            Ingredient i = TileEntityDrinkMixer.findMatchingIngredient(ingredient);
            if (i == null || ing0.id == i.id || ing1.id == i.id) {
                return false;
            }
            this.ingredients.set(2, (Object)ingredient);
            this.syncInventory();
            return true;
        }
        return false;
    }

    public boolean isMixing() {
        return this.mixing;
    }

    private boolean isMixerFull() {
        return MixerRecipes.isValidRecipe(this.ingredients);
    }

    public boolean canMix() {
        return !this.mixing && this.isMixerFull();
    }

    @Override
    public boolean isActive() {
        return this.isMixing();
    }

    @Override
    public float getProgress(float partialTicks) {
        return ((float)this.ticks + partialTicks) / 80.0f;
    }

    @Override
    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b(BlockDrinkMixer.FACING);
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    protected void syncInventory() {
        TCPacketHandler.INSTANCE.sendToDimension(new MessageMixerInventory(this), this.func_145831_w().field_73011_w.getDimension());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbttagcompound = this.func_189515_b(new NBTTagCompound());
        return nbttagcompound;
    }

    @Nonnull
    public ItemStack getResult(NonNullList<ItemStack> ingredients2) {
        return DrinkMixerRegistry.getResult(ingredients2);
    }
}

