/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.build.world;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.tropicraft.core.common.block.BlockBundle;
import net.tropicraft.core.common.block.BlockTropicraftLog;
import net.tropicraft.core.common.build.ITileEntityCustomGenData;
import net.tropicraft.core.common.build.SchematicData;
import net.tropicraft.core.common.build.world.Build;
import net.tropicraft.core.common.build.world.BuildJob;
import net.tropicraft.core.common.enums.TropicraftLogs;
import net.tropicraft.core.registry.BlockRegistry;

public class BuildManager {
    public List<BuildJob> activeBuilds;
    public List<String> buildNames;
    public int nextBuildID = 0;
    public int build_rate = 100000;
    public int build_rand = 20;
    public Block placeholderID = Blocks.field_150348_b;

    public BuildManager() {
        this.activeBuilds = new LinkedList<BuildJob>();
        this.buildNames = new LinkedList<String>();
    }

    public void updateTick() {
        for (int i = 0; i < this.activeBuilds.size(); ++i) {
            BuildJob bj = this.activeBuilds.get(i);
            if (bj == null) continue;
            if (bj.build_active) {
                bj.updateTick();
                this.updateBuildProgress(bj);
                continue;
            }
            this.activeBuilds.remove(bj);
        }
    }

    public boolean isBuildActive(int id) {
        for (int i = 0; i < this.activeBuilds.size(); ++i) {
            BuildJob bj = this.activeBuilds.get(i);
            if (bj.id != id) continue;
            return true;
        }
        return false;
    }

    public boolean isBuildActive(Build build) {
        for (int i = 0; i < this.activeBuilds.size(); ++i) {
            BuildJob bj = this.activeBuilds.get(i);
            if (bj.build != build) continue;
            return true;
        }
        return false;
    }

    public int newBuild(int x, int y, int z, String name) {
        int buildID = this.nextBuildID++;
        BuildJob newBuild = new BuildJob(buildID, x, y, z, name);
        this.addBuild(newBuild);
        return buildID;
    }

    public int newBuild(Build build) {
        int buildID = this.nextBuildID++;
        BuildJob newBuild = new BuildJob(buildID, build);
        this.addBuild(newBuild);
        return buildID;
    }

    public void addBuild(BuildJob buildJob) {
        this.activeBuilds.add(buildJob);
        buildJob.buildStart();
    }

    public void addBuild(BuildJob build, int x, int y, int z) {
        this.activeBuilds.add(build);
        build.buildStart();
    }

    public void updateBuildProgress(BuildJob buildJob) {
        boolean replaceAir;
        Build build = buildJob.build;
        ++buildJob.build_currentTick;
        WorldServer worldRef = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(buildJob.build.dim);
        if (buildJob.timeout > 0) {
            --buildJob.timeout;
            Build b = buildJob.build;
            worldRef.func_147458_c(buildJob.build_startX, buildJob.build_startY, buildJob.build_startZ, buildJob.build_startX + b.map_sizeX, buildJob.build_startY + b.map_sizeY, buildJob.build_startZ + b.map_sizeZ);
            return;
        }
        this.build_rate = 100000;
        this.build_rate = 25000;
        this.build_rate = 1000;
        this.build_rate = buildJob.build_rate;
        boolean bl = replaceAir = !buildJob.useFirstPass;
        if (buildJob.neverPlaceAir) {
            replaceAir = false;
        }
        Block id = null;
        buildJob.curLayerCountMax = build.map_sizeX * build.map_sizeZ;
        buildJob.doRandomBuild = false;
        try {
            if (buildJob.doRandomBuild) {
                if (worldRef.field_73012_v.nextInt(this.build_rand) != 0) {
                    return;
                }
                boolean first = true;
                for (int tryCount = 0; (first || BuildManager.isAir(id)) && tryCount < 300; ++tryCount) {
                    first = false;
                    buildJob.build_loopTickX = worldRef.field_73012_v.nextInt(build.map_sizeX);
                    buildJob.build_loopTickZ = worldRef.field_73012_v.nextInt(build.map_sizeZ);
                    if (!((float)buildJob.curLayerCount / (float)buildJob.curLayerCountMax > 0.9f)) continue;
                    buildJob.doRandomBuild = false;
                    buildJob.build_loopTickX = 0;
                    buildJob.build_loopTickZ = 0;
                    return;
                }
            } else {
                for (int loopCount = 0; loopCount < this.build_rate; ++loopCount) {
                    if (buildJob.build_loopTickX >= build.map_sizeX) {
                        buildJob.build_loopTickX = 0;
                        ++buildJob.build_loopTickZ;
                    }
                    if (buildJob.build_loopTickZ >= build.map_sizeZ) {
                        buildJob.build_loopTickZ = 0;
                        ++buildJob.build_loopTickY;
                        buildJob.curLayerCount = 0;
                    }
                    if (buildJob.build_loopTickY >= build.map_sizeY) {
                        if (buildJob.pass == 2) {
                            this.buildComplete(buildJob);
                            buildJob.buildComplete();
                            if (buildJob.customGenCallback != null) {
                                buildJob.customGenCallback.genPassPre((World)worldRef, buildJob, -1);
                            }
                        } else {
                            ++buildJob.pass;
                            buildJob.build_loopTickX = 0;
                            buildJob.build_loopTickZ = 0;
                            buildJob.build_loopTickY = 0;
                            buildJob.timeout = 5;
                            if (buildJob.customGenCallback != null) {
                                buildJob.customGenCallback.genPassPre((World)worldRef, buildJob, buildJob.pass);
                            }
                            if (buildJob.pass == 1) {
                                // empty if block
                            }
                        }
                        return;
                    }
                    ++buildJob.curTick;
                    if (buildJob.pass == 0) {
                        Block checkCoord;
                        int xx = buildJob.build_startX + buildJob.build_loopTickX;
                        int yy = buildJob.build_startY + buildJob.build_loopTickY;
                        int zz = buildJob.build_startZ + buildJob.build_loopTickZ;
                        id = build.build_blockIDArr[buildJob.build_loopTickX][buildJob.build_loopTickY][buildJob.build_loopTickZ];
                        boolean skipGen = false;
                        BlockPos coords = new BlockPos(xx, yy, zz);
                        if (buildJob.useRotationBuild) {
                            coords = buildJob.build.backwardsCompatibleOldRotate ? BuildManager.rotate(coords, buildJob.direction, new Vec3d((double)buildJob.build_startX, (double)buildJob.build_startY, (double)buildJob.build_startZ), new Vec3d((double)build.map_sizeX, (double)build.map_sizeY, (double)build.map_sizeZ)) : BuildManager.rotateNew(coords, buildJob.direction, new Vec3d((double)buildJob.build_startX, (double)buildJob.build_startY, (double)buildJob.build_startZ), new Vec3d((double)build.map_sizeX, (double)build.map_sizeY, (double)build.map_sizeZ));
                        } else if (buildJob.centerBuildIfNoRotate) {
                            coords.func_177982_a(-MathHelper.func_76128_c((double)((double)build.map_sizeX / 2.0)), 0, -MathHelper.func_76128_c((double)((double)build.map_sizeZ / 2.0)));
                        }
                        if (buildJob.blockIDsNoBuildOver.size() > 0 && buildJob.blockIDsNoBuildOver.contains(checkCoord = worldRef.func_180495_p(coords).func_177230_c())) {
                            skipGen = true;
                        }
                        if (!skipGen) {
                            worldRef.func_180501_a(coords, Blocks.field_150350_a.func_176223_P(), buildJob.notifyFlag);
                        }
                    } else {
                        boolean tropiFixTemp = false;
                        if (!buildJob.build_blockPlaced[buildJob.build_loopTickX][buildJob.build_loopTickY][buildJob.build_loopTickZ]) {
                            id = build.build_blockIDArr[buildJob.build_loopTickX][buildJob.build_loopTickY][buildJob.build_loopTickZ];
                            int meta = build.build_blockMetaArr[buildJob.build_loopTickX][buildJob.build_loopTickY][buildJob.build_loopTickZ];
                            int xx = buildJob.build_startX + buildJob.build_loopTickX;
                            int yy = buildJob.build_startY + buildJob.build_loopTickY;
                            int zz = buildJob.build_startZ + buildJob.build_loopTickZ;
                            boolean skip = false;
                            if (buildJob.pass == 1 && buildJob.blockIDsSkipFirstPass.contains(id)) {
                                skip = true;
                            }
                            if (!(skip || !replaceAir && BuildManager.isAir(id))) {
                                Block checkCoord;
                                boolean skipGen;
                                BlockPos coords = new BlockPos(xx, yy, zz);
                                if (buildJob.useRotationBuild) {
                                    coords = buildJob.build.backwardsCompatibleOldRotate ? BuildManager.rotate(coords, buildJob.direction, new Vec3d((double)buildJob.build_startX, (double)buildJob.build_startY, (double)buildJob.build_startZ), new Vec3d((double)build.map_sizeX, (double)build.map_sizeY, (double)build.map_sizeZ)) : BuildManager.rotateNew(coords, buildJob.direction, new Vec3d((double)buildJob.build_startX, (double)buildJob.build_startY, (double)buildJob.build_startZ), new Vec3d((double)build.map_sizeX, (double)build.map_sizeY, (double)build.map_sizeZ));
                                    if (tropiFixTemp) {
                                        if (id == BlockRegistry.bundles) {
                                            IBlockState state = id.func_176223_P().func_177226_a(BlockBundle.BUNDLE_AXIS, (Comparable)BlockLog.EnumAxis.Y);
                                            meta = id.func_176201_c(state);
                                        } else if (id == BlockRegistry.logs) {
                                            IBlockState state = id.func_176223_P().func_177226_a(BlockTropicraftLog.VARIANT, (Comparable)((Object)TropicraftLogs.PALM));
                                            meta = id.func_176201_c(state);
                                        }
                                    } else {
                                        int tryMeta = this.rotateMeta((World)worldRef, coords, buildJob.rotation, id, meta);
                                        if (tryMeta != -1) {
                                            meta = tryMeta;
                                        }
                                    }
                                } else if (buildJob.centerBuildIfNoRotate) {
                                    coords.func_177982_a(-MathHelper.func_76128_c((double)((double)build.map_sizeX / 2.0)), 0, -MathHelper.func_76128_c((double)((double)build.map_sizeZ / 2.0)));
                                }
                                if (id != null || BuildManager.isAir(id)) {
                                    skipGen = false;
                                    if (buildJob.blockIDsNoBuildOver.size() > 0 && buildJob.blockIDsNoBuildOver.contains(checkCoord = worldRef.func_180495_p(coords).func_177230_c())) {
                                        skipGen = true;
                                    }
                                    if (!skipGen) {
                                        IBlockState state = id.func_176203_a(meta);
                                        worldRef.func_180501_a(coords, state, 2);
                                    }
                                } else {
                                    System.out.println("BUILDMOD SEVERE: schematic contains non existant blockID: " + id + ", replacing with blockID: " + this.placeholderID);
                                    skipGen = false;
                                    if (buildJob.blockIDsNoBuildOver.size() > 0 && buildJob.blockIDsNoBuildOver.contains(checkCoord = worldRef.func_180495_p(coords).func_177230_c())) {
                                        skipGen = true;
                                    }
                                    if (!skipGen) {
                                        worldRef.func_180501_a(coords, this.placeholderID.func_176223_P(), buildJob.notifyFlag);
                                    }
                                }
                                buildJob.build_blockPlaced[buildJob.build_loopTickX][buildJob.build_loopTickY][buildJob.build_loopTickZ] = true;
                                ++buildJob.curLayerCount;
                            } else {
                                --loopCount;
                            }
                        }
                    }
                    ++buildJob.build_loopTickX;
                }
            }
        }
        catch (Exception ex) {
            buildJob.build_active = false;
            ex.printStackTrace();
        }
    }

    public static void rotateSet(BuildJob parBuildJob, BlockPos coords, IBlockState blockState) {
        coords = BuildManager.rotate(coords, parBuildJob.direction, new Vec3d((double)parBuildJob.build_startX, (double)parBuildJob.build_startY, (double)parBuildJob.build_startZ), new Vec3d((double)parBuildJob.build.map_sizeX, (double)parBuildJob.build.map_sizeY, (double)parBuildJob.build.map_sizeZ));
        WorldServer world = DimensionManager.getWorld((int)parBuildJob.build.dim);
        if (world != null) {
            world.func_180501_a(coords, blockState, 2);
        }
    }

    public static BlockPos rotatePos(BuildJob parBuildJob, BlockPos coords) {
        BlockPos pos = BuildManager.rotate(coords, parBuildJob.direction, new Vec3d((double)parBuildJob.build_startX, (double)parBuildJob.build_startY, (double)parBuildJob.build_startZ), new Vec3d((double)parBuildJob.build.map_sizeX, (double)parBuildJob.build.map_sizeY, (double)parBuildJob.build.map_sizeZ));
        return pos;
    }

    public static BlockPos rotate(BlockPos coords, int direction, Vec3d start, Vec3d size) {
        double rotation = direction * 90 + 180;
        double centerX = start.field_72450_a + size.field_72450_a / 2.0;
        double centerZ = start.field_72449_c + size.field_72449_c / 2.0;
        double vecX = (double)coords.func_177958_n() - centerX + 0.05;
        double vecZ = (double)coords.func_177952_p() - centerZ + 0.05;
        double distToCenter = Math.sqrt(vecX * vecX + vecZ * vecZ);
        double rotYaw = (double)((float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI)) - rotation;
        double newX = start.field_72450_a + Math.cos(rotYaw * 0.017453) * distToCenter;
        double newZ = start.field_72449_c + Math.sin(rotYaw * 0.017453) * distToCenter;
        if (direction == 1) {
            newZ += 1.0;
        } else if (direction == 2) {
            newX += 1.0;
            newZ += 1.0;
        } else if (direction == 3) {
            newX += 1.0;
        }
        return new BlockPos((int)Math.floor(newX), coords.func_177956_o(), (int)Math.floor(newZ));
    }

    public static BlockPos rotateNew(BlockPos coords, int direction, Vec3d start, Vec3d size) {
        double rotation = (double)direction * Math.PI / 2.0;
        double centerX = start.field_72450_a + size.field_72450_a / 2.0;
        double centerZ = start.field_72449_c + size.field_72449_c / 2.0;
        double vecX = (double)coords.func_177958_n() + 0.5 - centerX;
        double vecZ = (double)coords.func_177952_p() + 0.5 - centerZ;
        Vec3d vec = new Vec3d(vecX, 0.0, vecZ);
        vec = vec.func_178785_b((float)rotation);
        return new BlockPos((int)Math.floor(start.field_72450_a + vec.field_72450_a), coords.func_177956_o(), (int)Math.floor(start.field_72449_c + vec.field_72449_c));
    }

    public int rotateMeta(World par1World, BlockPos coords, double rotation, Block id, int meta) {
        int dir = MathHelper.func_76128_c((double)(rotation * 4.0 / 360.0 + 0.5)) & 3;
        dir = (int)rotation / 90 & 3;
        if (dir == 0) {
            return meta;
        }
        Block block = id;
        if (block instanceof BlockStairs) {
            int rotateMeta = meta & 4;
            int fMeta = -1;
            if (dir != 0) {
                if (dir == 1) {
                    if (meta == 0) {
                        fMeta = 3;
                    } else if (meta == 1) {
                        fMeta = 2;
                    } else if (meta == 2) {
                        fMeta = 0;
                    } else if (meta == 3) {
                        fMeta = 1;
                    }
                } else if (dir == 2) {
                    if (meta == 0) {
                        fMeta = 1;
                    } else if (meta == 1) {
                        fMeta = 0;
                    } else if (meta == 2) {
                        fMeta = 3;
                    } else if (meta == 3) {
                        fMeta = 2;
                    }
                } else if (dir == 3) {
                    if (meta == 0) {
                        fMeta = 2;
                    } else if (meta == 1) {
                        fMeta = 3;
                    } else if (meta == 2) {
                        fMeta = 1;
                    } else if (meta == 3) {
                        fMeta = 0;
                    }
                }
            }
            return fMeta | rotateMeta;
        }
        if (block instanceof BlockLadder) {
            IBlockState state = block.func_176203_a(meta);
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockLadder.field_176382_a);
            for (int i = 0; i < dir; ++i) {
                facing = facing.func_176735_f();
            }
            state = state.func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)facing);
            meta = block.func_176201_c(state);
            return meta;
        }
        return -1;
    }

    public void buildComplete(BuildJob buildJob) {
        this.spawnLevelEntities(buildJob);
    }

    public void spawnLevelEntities(BuildJob buildJob) {
        Build build = buildJob.build;
        WorldServer worldRef = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(build.dim);
        if (build.entities != null) {
            for (int var17 = 0; var17 < build.entities.func_74745_c(); ++var17) {
                NBTTagCompound var16 = build.entities.func_150305_b(var17);
                Entity entity = EntityList.func_75615_a((NBTTagCompound)var16, (World)worldRef);
            }
        }
        if (build.tileEntities != null) {
            for (int var21 = 0; var21 < build.tileEntities.func_74745_c(); ++var21) {
                NBTTagCompound nbt;
                NBTTagCompound var20 = build.tileEntities.func_150305_b(var21);
                TileEntity var13 = worldRef.func_175625_s(new BlockPos(build.map_coord_minX + var20.func_74762_e("x"), buildJob.build_startY + var20.func_74762_e("y"), build.map_coord_minZ + var20.func_74762_e("z")));
                if (var13 instanceof SchematicData) {
                    ((SchematicData)var13).readFromNBT(var20, build);
                } else if (var13 != null) {
                    var13.func_145839_a(var20);
                }
                if (buildJob.customGenCallback != null && (nbt = buildJob.customGenCallback.getInitNBTTileEntity()) != null && var13 instanceof ITileEntityCustomGenData) {
                    ((ITileEntityCustomGenData)var13).initWithNBT(nbt);
                }
                if (var13 == null) continue;
                var13.func_174878_a(new BlockPos(build.map_coord_minX + var13.func_174877_v().func_177958_n(), buildJob.build_startY + var13.func_174877_v().func_177956_o(), build.map_coord_minZ + var13.func_174877_v().func_177952_p()));
                try {
                    SPacketUpdateTileEntity packet = var13.func_189518_D_();
                    if (packet == null) continue;
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148540_a((Packet)packet);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static boolean isAir(Block parBlock) {
        return parBlock == Blocks.field_150350_a;
    }
}

