/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.donations;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class FireworkUtil {
    private static final Random rand = new Random();

    @Nonnull
    public static EntityFireworkRocket getRandomFirework(@Nonnull World world) {
        return FireworkUtil.getRandomFirework(world, new BlockPos(0, 0, 0));
    }

    @Nonnull
    public static EntityFireworkRocket getRandomFirework(@Nonnull World world, @Nonnull BlockPos pos) {
        ItemStack firework = new ItemStack(Items.field_151152_bP);
        firework.func_77982_d(new NBTTagCompound());
        NBTTagCompound expl = new NBTTagCompound();
        expl.func_74757_a("Flicker", true);
        expl.func_74757_a("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ItemDye.field_150922_c[rand.nextInt(16)];
        }
        expl.func_74783_a("Colors", colors);
        byte type = (byte)(rand.nextInt(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        expl.func_74774_a("Type", type);
        NBTTagList explosions = new NBTTagList();
        explosions.func_74742_a((NBTBase)expl);
        NBTTagCompound fireworkTag = new NBTTagCompound();
        fireworkTag.func_74782_a("Explosions", (NBTBase)explosions);
        fireworkTag.func_74774_a("Flight", (byte)1);
        firework.func_77983_a("Fireworks", (NBTBase)fireworkTag);
        EntityFireworkRocket e = new EntityFireworkRocket(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, firework);
        return e;
    }

    @Nonnull
    public static EntityFireworkRocket getRandomPRFirework(@Nonnull World world, @Nonnull BlockPos pos) {
        ItemStack firework = new ItemStack(Items.field_151152_bP);
        firework.func_77982_d(new NBTTagCompound());
        NBTTagCompound expl = new NBTTagCompound();
        expl.func_74757_a("Flicker", true);
        expl.func_74757_a("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        int[] PR_COLORS = new int[]{11743532, 0xF0F0F0, 2437522, 6998340, 16105792, 1021572};
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = PR_COLORS[rand.nextInt(PR_COLORS.length)];
        }
        expl.func_74783_a("Colors", colors);
        byte type = (byte)(rand.nextInt(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        expl.func_74774_a("Type", type);
        NBTTagList explosions = new NBTTagList();
        explosions.func_74742_a((NBTBase)expl);
        NBTTagCompound fireworkTag = new NBTTagCompound();
        fireworkTag.func_74782_a("Explosions", (NBTBase)explosions);
        fireworkTag.func_74774_a("Flight", (byte)1);
        firework.func_77983_a("Fireworks", (NBTBase)fireworkTag);
        EntityFireworkRocket e = new EntityFireworkRocket(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, firework);
        return e;
    }

    public static void spawnFirework(@Nonnull BlockPos block, int dimID) {
        FireworkUtil.spawnFirework(block, dimID, 0);
    }

    public static void spawnFirework(@Nonnull BlockPos pos, int dimID, int range) {
        WorldServer world = DimensionManager.getWorld((int)dimID);
        BlockPos spawnPos = pos;
        if (range > 0) {
            spawnPos = new BlockPos(FireworkUtil.moveRandomly(spawnPos.func_177958_n(), range), (double)spawnPos.func_177956_o(), FireworkUtil.moveRandomly(spawnPos.func_177952_p(), range));
            IBlockState bs = world.func_180495_p(spawnPos);
            int tries = -1;
            while (!world.func_175623_d(new BlockPos((Vec3i)spawnPos)) && !bs.func_177230_c().func_176200_f((IBlockAccess)world, spawnPos)) {
                if (++tries <= 100) continue;
                return;
            }
        }
        world.func_72838_d((Entity)FireworkUtil.getRandomPRFirework((World)world, spawnPos));
    }

    private static double moveRandomly(double base, double range) {
        return base + 0.5 + rand.nextDouble() * range - range / 2.0;
    }
}

