/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.drinks;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.tropicraft.core.common.drinks.DrinkAction;
import net.tropicraft.core.common.drinks.DrinkActionFood;
import net.tropicraft.core.common.drinks.DrinkActionPotion;
import net.tropicraft.core.common.item.ItemCocktail;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class Ingredient
implements Comparable<Ingredient> {
    public static final Ingredient[] ingredientsList = new Ingredient[24];
    public static final Ingredient sugar = new Ingredient(0, new ItemStack(Items.field_151102_aT), false, 0xFFFFFF, 0.1f).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient lemon = new Ingredient(5, new ItemStack(ItemRegistry.lemon), true, 0xFFFF00).addAction(new DrinkActionFood(2, 0.2f));
    public static final Ingredient lime = new Ingredient(6, new ItemStack(ItemRegistry.lime), true, 0x7FFF00).addAction(new DrinkActionFood(2, 0.2f));
    public static final Ingredient orange = new Ingredient(7, new ItemStack(ItemRegistry.orange), true, 16753920).addAction(new DrinkActionFood(3, 0.2f));
    public static final Ingredient grapefruit = new Ingredient(8, new ItemStack(ItemRegistry.grapefruit), true, 16737095).addAction(new DrinkActionFood(4, 0.2f));
    public static final Ingredient pineapple = new Ingredient(9, new ItemStack(BlockRegistry.pineapple, 1, 0), false, 0xEEFF00).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient pineappleCubes = new Ingredient(10, new ItemStack(ItemRegistry.pineappleCubes), false, 0xEEFF00, 0.1f).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient coconut = new Ingredient(11, new ItemStack(BlockRegistry.coconut), false, 0xEFEFEF).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient coconutChunk = new Ingredient(12, new ItemStack(ItemRegistry.coconutChunk), false, 0xEFEFEF).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient sugarcane = new Ingredient(13, new ItemStack(Items.field_151120_aE), false, 11665259, 0.1f);
    public static final Ingredient roastedCoffeeBean = new Ingredient(14, new ItemStack(ItemRegistry.coffeeBeans, 1, 1), false, 6833196, 0.95f).addAction(new DrinkActionFood(4, 0.2f)).addAction(new DrinkActionPotion(MobEffects.field_76424_c, 5, 1));
    public static final Ingredient waterBucket = new Ingredient(15, new ItemStack(ItemRegistry.tropicsWaterBucket), false, 0xFFFFFF);
    public static final Ingredient milkBucket = new Ingredient(16, new ItemStack(Items.field_151117_aB), false, 0xFFFFFF, 0.1f).addAction(new DrinkActionFood(2, 0.2f));
    public static final Ingredient cocoaBean = new Ingredient(17, new ItemStack(Items.field_151100_aR, 1, 3), false, 8411710, 0.95f).addAction(new DrinkActionFood(4, 0.2f));
    @Nonnull
    private ItemStack itemStack;
    private int color;
    public int id;
    private boolean primary;
    private float alpha = 1.0f;
    private List<DrinkAction> actions = new LinkedList<DrinkAction>();

    public Ingredient() {
        this.itemStack = ItemStack.field_190927_a;
    }

    public Ingredient(int id, @Nonnull ItemStack ingredientItemStack, boolean primary, int color) {
        if (ingredientsList[id] != null) {
            throw new IllegalArgumentException("Ingredient Id slot " + id + " already occupied by " + Ingredient.ingredientsList[id].itemStack.func_77977_a() + "!");
        }
        this.id = id;
        this.itemStack = ingredientItemStack;
        this.primary = primary;
        this.color = color;
        Ingredient.ingredientsList[id] = this;
    }

    public Ingredient(int id, @Nonnull ItemStack ingredientItemStack, boolean primary, int color, float alpha) {
        this(id, ingredientItemStack, primary, color);
        this.alpha = alpha;
    }

    public Ingredient addAction(DrinkAction action) {
        this.actions.add(action);
        return this;
    }

    @Nonnull
    public ItemStack getIngredient() {
        return this.itemStack;
    }

    public Item getIngredientItem() {
        return this.itemStack.func_77973_b();
    }

    public int getColor() {
        return this.color;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public int compareTo(Ingredient other) {
        return this.id < other.id ? -1 : (this.id == other.id ? 0 : 1);
    }

    public void onDrink(EntityPlayer player) {
        for (DrinkAction action : this.actions) {
            action.onDrink(player);
        }
    }

    public static Ingredient findMatchingIngredient(@Nonnull ItemStack stack) {
        for (Ingredient ingredient : ingredientsList) {
            if (ingredient == null || !ItemStack.func_77989_b((ItemStack)ingredient.getIngredient(), (ItemStack)stack)) continue;
            return ingredient;
        }
        return null;
    }

    public static List<Ingredient> listIngredients(ItemStack stack) {
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        if (!stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.cocktail) {
            for (Ingredient ingredient : ItemCocktail.getIngredients(stack)) {
                is.add(ingredient);
            }
        } else if (!stack.func_190926_b()) {
            Ingredient i = Ingredient.findMatchingIngredient(stack);
            is.add(i);
        }
        return is;
    }
}

