/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.tropicraft.core.common.entity.EntityLandHostile;
import net.tropicraft.core.common.sound.TropicraftSounds;
import net.tropicraft.core.registry.BlockRegistry;

public class EntityEIH
extends EntityLandHostile
implements IMob {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityEIH.class, (DataSerializer)DataSerializers.field_187192_b);
    public int STATE_SLEEP = 0;
    public int STATE_AWARE = 1;
    public int STATE_ANGRY = 2;

    public EntityEIH(World world) {
        super(world);
        this.func_70105_a(1.2f, 3.8f);
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(100.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee(this, 1.0, false){

            public boolean func_75250_a() {
                if (EntityEIH.this.getState() != EntityEIH.this.STATE_ANGRY) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        EntityAILeapAtTarget leap = new EntityAILeapAtTarget((EntityLiving)this, 0.4f);
        leap.func_75248_a(0);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)leap);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander(this, 0.8){

            public boolean func_75250_a() {
                if (EntityEIH.this.getState() != EntityEIH.this.STATE_ANGRY) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    public int getState() {
        this.func_70105_a(1.2f, 3.25f);
        return (Integer)this.func_184212_Q().func_187225_a(STATE);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.equals(DamageSource.field_76380_i)) {
            return super.func_70097_a(source, amount);
        }
        this.func_184212_Q().func_187227_b(STATE, (Object)this.STATE_ANGRY);
        if (source.func_76364_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76364_f();
            ItemStack heldItem = player.func_184614_ca();
            if (!heldItem.func_190926_b() && heldItem.func_77973_b().getHarvestLevel(heldItem, "pickaxe", player, null) >= 1) {
                return super.func_70097_a(source, amount);
            }
            this.func_184185_a(TropicraftSounds.HEAD_LAUGHING, this.func_70599_aP(), this.func_70647_i());
            this.func_70604_c((EntityLivingBase)player);
        }
        return true;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("state", (byte)this.getState());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_184212_Q().func_187227_b(STATE, (Object)compound.func_74771_c("state"));
    }

    protected SoundEvent func_184639_G() {
        if (this.getState() == this.STATE_ANGRY && this.func_70638_az() != null) {
            return this.field_70146_Z.nextInt(10) == 0 ? TropicraftSounds.HEAD_MED : null;
        }
        if (this.getState() == this.STATE_ANGRY) {
            return this.field_70146_Z.nextInt(10) == 0 ? TropicraftSounds.HEAD_SHORT : null;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return TropicraftSounds.HEAD_PAIN;
    }

    protected SoundEvent func_184615_bR() {
        return TropicraftSounds.HEAD_DEATH;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        int numDrops = 3 + this.field_70146_Z.nextInt(1 + lootingModifier);
        if (!this.field_70170_p.field_72995_K) {
            this.func_145779_a(Item.func_150898_a((Block)BlockRegistry.chunk), numDrops);
        }
    }

    protected void func_70623_bb() {
        Event.Result result = null;
        if (this.func_104002_bU()) {
            this.field_70708_bq = 0;
        } else if ((this.field_70708_bq & 0x1F) == 31 && (result = ForgeEventFactory.canEntityDespawn((EntityLiving)this)) != Event.Result.DEFAULT) {
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
            } else {
                this.func_70106_y();
            }
        } else {
            EntityPlayer entity = this.field_70170_p.func_72890_a((Entity)this, -1.0);
            if (entity != null) {
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70163_u - this.field_70163_u;
                double d2 = entity.field_70161_v - this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.func_70692_ba() && d3 > 16384.0) {
                    this.func_70106_y();
                }
                double despawnRange = 529.0;
                if (this.field_70708_bq > 1200 && this.field_70146_Z.nextInt(800) == 0 && d3 > despawnRange && this.func_70692_ba()) {
                    this.func_70106_y();
                } else if (d3 < despawnRange) {
                    this.field_70708_bq = 0;
                }
            }
        }
    }
}

