/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.tropicraft.core.common.enums.AshenMasks;
import net.tropicraft.core.registry.ItemRegistry;

public class EntityLostMask
extends Entity {
    public int type = -1;
    public float bobber;
    private double launchedSpeed = 1.0;
    private static final DataParameter<Integer> MASK_TYPE = EntityDataManager.func_187226_a(EntityLostMask.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ROTATOR_X = EntityDataManager.func_187226_a(EntityLostMask.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ROTATOR_Y = EntityDataManager.func_187226_a(EntityLostMask.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ROTATOR_Z = EntityDataManager.func_187226_a(EntityLostMask.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityLostMask(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityLostMask(World world, int type, double x, double y, double z, double angle) {
        this(world);
        this.func_70107_b(x, y, z);
        this.field_70159_w = Math.cos(Math.toRadians(angle + 90.0)) * this.launchedSpeed;
        this.field_70179_y = Math.sin(Math.toRadians(angle + 90.0)) * this.launchedSpeed;
        double subAngle = MathHelper.func_76138_g((double)angle);
        double subAngle2 = subAngle + (180.0 - subAngle) * 2.0;
        this.field_70177_z = (float)subAngle2;
        this.type = type;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa == 1 && this.type >= 0) {
                this.setType(this.type);
            }
            if (this.field_70173_aa >= 24000) {
                this.func_70106_y();
            }
        }
        if (this.field_70122_E) {
            this.field_70159_w *= 0.5;
            this.field_70179_y *= 0.5;
            this.field_70181_x = 0.0;
        }
        if (this.checkForWater(0)) {
            this.field_70181_x = 0.02f;
            this.field_70159_w *= (double)0.95f;
            this.field_70179_y *= (double)0.95f;
        } else {
            int xMod = this.field_70170_p.field_73012_v.nextInt(10);
            int yMod = this.field_70170_p.field_73012_v.nextInt(30);
            int zMod = this.field_70170_p.field_73012_v.nextInt(10);
            int[] a = this.getRotator();
            a[0] = a[0] + xMod;
            a[1] = a[1] + yMod;
            a[2] = a[2] + zMod;
            this.setRotator(a);
            this.field_70181_x -= (double)0.05f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(MASK_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(ROTATOR_X, (Object)0);
        this.field_70180_af.func_187214_a(ROTATOR_Y, (Object)0);
        this.field_70180_af.func_187214_a(ROTATOR_Z, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setType(nbt.func_74762_e("MaskType"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("MaskType", this.getType());
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.func_180431_b(par1DamageSource)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70018_K();
            EntityPlayer entityplayer = null;
            if (par1DamageSource.func_76346_g() instanceof EntityPlayer) {
                entityplayer = (EntityPlayer)par1DamageSource.func_76346_g();
            }
            if (entityplayer != null && entityplayer.field_71075_bZ.field_75098_d) {
                return true;
            }
            this.dropItemStack();
        }
        return true;
    }

    public void dropItemStack() {
        this.func_70099_a(new ItemStack(ItemRegistry.maskMap.get(AshenMasks.VALUES[this.getType()]), 1, this.getType()), 0.0f);
    }

    private void setRotator(int[] a) {
        this.field_70180_af.func_187227_b(ROTATOR_X, (Object)a[0]);
        this.field_70180_af.func_187227_b(ROTATOR_Y, (Object)a[1]);
        this.field_70180_af.func_187227_b(ROTATOR_Z, (Object)a[2]);
    }

    public int[] getRotator() {
        return new int[]{(Integer)this.field_70180_af.func_187225_a(ROTATOR_X), (Integer)this.field_70180_af.func_187225_a(ROTATOR_Y), (Integer)this.field_70180_af.func_187225_a(ROTATOR_Z)};
    }

    private void setType(int i) {
        this.field_70180_af.func_187227_b(MASK_TYPE, (Object)i);
    }

    public boolean checkForWater(int offset) {
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u + (double)offset, this.field_70161_v);
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        return state.func_185904_a() == Material.field_151586_h;
    }

    public int getMode() {
        return 0;
    }

    public int getType() {
        return (Integer)this.field_70180_af.func_187225_a(MASK_TYPE);
    }

    public int getDirection() {
        return 0;
    }
}

