/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.ai.EntityAIWanderNotLazy;
import net.tropicraft.core.common.entity.egg.EntityTropiSpiderEgg;

public class EntityTropiSpider
extends EntitySpider
implements IMob {
    private static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(EntityTropiSpider.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final int SPIDER_MATURE_AGE = 12000;
    private static final int SPIDER_MAX_EGGS = 10;
    private static final long SPIDER_MIN_EGG_DELAY = 12000L;
    private static final int SPIDER_EGG_CHANCE = 1000;
    private BlockPos nestSite;
    private EntityTropiSpider mother = null;
    private long ticksSinceLastEgg = 0L;
    public byte initialType = 0;

    public EntityTropiSpider(World par1World) {
        super(par1World);
        this.func_70105_a(1.4f, 0.9f);
        this.field_70173_aa = 12000;
        this.ticksSinceLastEgg = this.field_70173_aa;
    }

    public EntityTropiSpider(World w, int motherID) {
        this(w);
        this.setType((byte)2);
        this.field_70173_aa = 0;
        Entity ent = this.field_70170_p.func_73045_a(motherID);
        if (ent != null) {
            this.mother = (EntityTropiSpider)ent;
        }
        this.field_70170_p.func_73045_a(this.func_145782_y());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)this.initialType);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.8, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderNotLazy((EntityCreature)this, 0.8, 40));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (damageSrc.func_76346_g() != null && damageSrc.func_76346_g() instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)damageSrc.func_76346_g());
        }
        super.func_70665_d(damageSrc, damageAmount);
    }

    protected void func_70628_a(boolean par1, int par2) {
        int j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(1 + par2);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151007_F, 1);
        }
    }

    public boolean func_70617_f_() {
        return this.func_70841_p() && this.func_70661_as().func_75500_f();
    }

    public boolean func_70841_p() {
        return this.field_70123_F;
    }

    public void func_70636_d() {
        this.field_70143_R = 0.0f;
        if (this.getType() == 2) {
            this.func_70105_a(0.9f, 0.7f);
        } else {
            this.func_70105_a(1.4f, 0.9f);
        }
        super.func_70636_d();
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 128.0) {
            Util.tryMoveToEntityLivingLongDist((EntityLiving)this, (Entity)this.func_70638_az(), 0.8f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.field_70122_E && this.field_70146_Z.nextInt(3) == 0 && this.func_70638_az().func_70032_d((Entity)this) < 5.0f) {
            this.func_70661_as().func_75499_g();
            this.func_70664_aZ();
            this.field_70747_aH = 0.3f;
        } else {
            this.field_70747_aH = 0.2f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getType() == 2) {
                if (this.field_70173_aa >= 12000) {
                    this.setType((byte)0);
                }
                if (this.mother != null) {
                    if (this.func_70068_e((Entity)this.mother) > 16.0) {
                        Util.tryMoveToEntityLivingLongDist((EntityLiving)this, (Entity)this.mother, 0.8f);
                    } else {
                        this.func_70661_as().func_75499_g();
                    }
                    if (this.mother.func_70638_az() != null) {
                        this.func_70624_b(this.mother.func_70638_az());
                    }
                }
            }
            if (this.getType() == 0) {
                if (this.mother != null) {
                    if (this.mother.field_70128_L) {
                        this.mother = null;
                        this.func_70661_as().func_75499_g();
                        this.func_70624_b(null);
                    }
                    this.func_70624_b((EntityLivingBase)this.mother);
                }
                if (this.field_70146_Z.nextInt(1000) == 0 && this.ticksSinceLastEgg > 12000L && this.field_70173_aa % 80 == 0) {
                    this.buildNest();
                }
            }
            if (this.getType() == 1 && this.nestSite != null) {
                if (this.ticksSinceLastEgg < 2000L) {
                    if (this.func_174818_b(this.nestSite) > 16.0) {
                        Util.tryMoveToXYZLongDist((EntityLiving)this, this.nestSite, 0.9f);
                    }
                } else {
                    this.nestSite = null;
                }
            }
            ++this.ticksSinceLastEgg;
        }
    }

    protected SoundEvent func_184639_G() {
        return this.field_70146_Z.nextInt(20) == 0 ? super.func_184639_G() : null;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (this.getType() == 2) {
            if (this.field_70146_Z.nextInt(20) == 0) {
                super.func_180429_a(pos, blockIn);
            }
        } else {
            super.func_180429_a(pos, blockIn);
        }
    }

    public boolean func_70104_M() {
        return this.getType() != 1;
    }

    public void buildNest() {
        if (!this.field_70170_p.field_72995_K) {
            this.setType((byte)1);
            int r = this.field_70146_Z.nextInt(10) + 1;
            if (r < 2) {
                return;
            }
            for (int i = 0; i < r; ++i) {
                EntityTropiSpiderEgg egg = new EntityTropiSpiderEgg(this.field_70170_p);
                egg.motherID = this.func_145782_y();
                egg.func_70107_b((float)this.func_180425_c().func_177958_n() + this.field_70146_Z.nextFloat(), this.func_180425_c().func_177956_o(), (float)this.func_180425_c().func_177952_p() + this.field_70146_Z.nextFloat());
                this.field_70170_p.func_72838_d((Entity)egg);
                this.ticksSinceLastEgg = 0L;
            }
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    BlockPos pos;
                    if (this.field_70146_Z.nextInt(8) != 0 || !this.field_70170_p.func_180495_p(pos = new BlockPos(this.func_180425_c().func_177958_n() - 2 + x, this.func_180425_c().func_177956_o(), this.func_180425_c().func_177952_p() - 2 + z)).func_177230_c().equals(Blocks.field_150350_a) || !this.field_70170_p.func_180495_p(pos.func_177979_c(1)).func_185904_a().func_76220_a()) continue;
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150321_G.func_176223_P());
                }
            }
            this.nestSite = this.func_180425_c();
        }
    }

    public void func_70014_b(NBTTagCompound n) {
        n.func_74768_a("ticks", this.field_70173_aa);
        n.func_74774_a("spiderType", this.getType());
        n.func_74772_a("timeSinceLastEgg", this.ticksSinceLastEgg);
        super.func_70014_b(n);
    }

    public void func_70037_a(NBTTagCompound n) {
        this.field_70173_aa = n.func_74762_e("ticks");
        this.setType(n.func_74771_c("spiderType"));
        this.ticksSinceLastEgg = n.func_74763_f("timeSinceLastEgg");
        super.func_70037_a(n);
    }

    public byte getType() {
        return (Byte)this.func_184212_Q().func_187225_a(TYPE);
    }

    public void setType(byte b) {
        this.func_184212_Q().func_187227_b(TYPE, (Object)b);
    }

    public void func_70110_aj() {
    }

    public static class Type {
        public static final byte ADULT = 0;
        public static final byte MOTHER = 1;
        public static final byte CHILD = 2;
    }
}

