/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.enums;

import net.tropicraft.core.common.enums.BlockHardnessValues;
import net.tropicraft.core.common.enums.ITropicraftVariant;

public enum TropicraftBundles implements ITropicraftVariant
{
    THATCH(0, BlockHardnessValues.THATCH.hardness, BlockHardnessValues.THATCH.resistance),
    BAMBOO(1, BlockHardnessValues.BAMBOO.hardness, BlockHardnessValues.BAMBOO.resistance);

    private final float resistance;
    private final float hardness;
    private final int meta;
    private static final TropicraftBundles[] META_LOOKUP;

    private TropicraftBundles(int meta, float hardness, float resistance) {
        this.meta = meta;
        this.hardness = hardness;
        this.resistance = resistance;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    public static TropicraftBundles byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    @Override
    public String getTypeName() {
        return "bundle";
    }

    static {
        META_LOOKUP = new TropicraftBundles[TropicraftBundles.values().length];
        TropicraftBundles[] tropicraftBundlesArray = TropicraftBundles.values();
        int n = tropicraftBundlesArray.length;
        for (int i = 0; i < n; ++i) {
            TropicraftBundles bundle;
            TropicraftBundles.META_LOOKUP[bundle.getMeta()] = bundle = tropicraftBundlesArray[i];
        }
    }
}

