/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.enums;

import java.util.Random;
import net.minecraft.block.material.MapColor;
import net.tropicraft.core.common.enums.ITropicraftVariant;

public enum TropicraftSands implements ITropicraftVariant
{
    PURIFIED(0, MapColor.field_151658_d),
    CORAL(1, MapColor.field_151671_v),
    FOAMY(2, MapColor.field_151651_C),
    VOLCANIC(3, MapColor.field_151646_E),
    MINERAL(4, MapColor.field_151658_d);

    private final int meta;
    private final MapColor color;
    private static final TropicraftSands[] META_LOOKUP;
    public static final TropicraftSands[] VALUES;

    private TropicraftSands(int meta, MapColor color) {
        this.meta = meta;
        this.color = color;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    public MapColor getColor() {
        return this.color;
    }

    public static TropicraftSands getRandomSand(Random rand) {
        int meta = rand.nextInt(META_LOOKUP.length);
        return META_LOOKUP[meta];
    }

    public static TropicraftSands byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    @Override
    public String getTypeName() {
        return "sand";
    }

    static {
        META_LOOKUP = new TropicraftSands[TropicraftSands.values().length];
        TropicraftSands[] tropicraftSandsArray = VALUES = TropicraftSands.values();
        int n = tropicraftSandsArray.length;
        for (int i = 0; i < n; ++i) {
            TropicraftSands sand;
            TropicraftSands.META_LOOKUP[sand.getMeta()] = sand = tropicraftSandsArray[i];
        }
    }
}

