/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.enums;

import net.minecraft.block.material.MapColor;
import net.tropicraft.core.common.enums.BlockHardnessValues;
import net.tropicraft.core.common.enums.ITropicraftVariant;

public enum TropicraftSlabs implements ITropicraftVariant
{
    BAMBOO(0, MapColor.field_151651_C, BlockHardnessValues.BAMBOO.hardness, BlockHardnessValues.BAMBOO.resistance),
    THATCH(1, MapColor.field_151673_t, BlockHardnessValues.THATCH.hardness, BlockHardnessValues.THATCH.resistance),
    CHUNK(2, MapColor.field_151646_E, BlockHardnessValues.CHUNK.hardness, BlockHardnessValues.CHUNK.resistance),
    PALM(3, MapColor.field_151650_B, BlockHardnessValues.PALM.hardness, BlockHardnessValues.PALM.resistance),
    MAHOGANY(4, MapColor.field_151650_B, BlockHardnessValues.MAHOGANY.hardness, BlockHardnessValues.MAHOGANY.resistance);

    private final float hardness;
    private final float resistance;
    private final int meta;
    private final MapColor mapColor;
    private static final TropicraftSlabs[] META_LOOKUP;
    public static final TropicraftSlabs[] VALUES;

    private TropicraftSlabs(int meta, MapColor mapColor, float hardness, float resistance) {
        this.meta = meta;
        this.mapColor = mapColor;
        this.hardness = hardness;
        this.resistance = resistance;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    public static int getMetaByName(String name) {
        for (TropicraftSlabs slab : META_LOOKUP) {
            if (!slab.func_176610_l().equals(name)) continue;
            return slab.getMeta();
        }
        return -1;
    }

    public static TropicraftSlabs byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    @Override
    public String getTypeName() {
        return "slab";
    }

    static {
        META_LOOKUP = new TropicraftSlabs[TropicraftSlabs.values().length];
        VALUES = TropicraftSlabs.values();
        TropicraftSlabs[] tropicraftSlabsArray = TropicraftSlabs.values();
        int n = tropicraftSlabsArray.length;
        for (int i = 0; i < n; ++i) {
            TropicraftSlabs slab;
            TropicraftSlabs.META_LOOKUP[slab.getMeta()] = slab = tropicraftSlabsArray[i];
        }
    }
}

