/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.event;

import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.capability.PlayerDataInstance;
import net.tropicraft.core.common.capability.WorldDataInstance;
import net.tropicraft.core.common.dimension.TropicraftWorldUtils;
import net.tropicraft.core.common.donations.TickerDonation;
import net.tropicraft.core.common.entity.placeable.EntityChair;
import net.tropicraft.core.common.worldgen.village.WorldEventListener;

public class MiscEvents {
    public World lastWorldTracked = null;
    public HashSet<Integer> lookupDimIDToRegisteredListener = new HashSet();

    @SubscribeEvent
    public void tickServer(TickEvent.ServerTickEvent event) {
        WorldServer world;
        WorldServer overworld = DimensionManager.getWorld((int)0);
        if (this.lastWorldTracked != overworld) {
            this.reset();
            this.lastWorldTracked = overworld;
        }
        if ((world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0)) != null && world instanceof WorldServer) {
            for (int ii = 0; ii < world.field_73010_i.size(); ++ii) {
                EntityPlayer player = (EntityPlayer)world.field_73010_i.get(ii);
                if (!(player instanceof EntityPlayerMP) || !((EntityPlayerMP)player).func_70644_a(MobEffects.field_76431_k) || !this.isSunset((World)world) || !(player.func_184187_bx() instanceof EntityChair)) continue;
                player.func_184210_p();
                TropicraftWorldUtils.teleportPlayer((EntityPlayerMP)player);
            }
        }
        if (world != null && event.phase == TickEvent.Phase.END) {
            TickerDonation.tick((World)world);
        }
    }

    @SubscribeEvent
    public void tickServer(TickEvent.WorldTickEvent event) {
        WorldDataInstance storage = (WorldDataInstance)event.world.getCapability(Tropicraft.WORLD_DATA_INSTANCE, null);
        if (storage != null) {
            storage.tick();
        }
        if (!this.lookupDimIDToRegisteredListener.contains(event.world.field_73011_w.getDimension())) {
            event.world.func_72954_a((IWorldEventListener)new WorldEventListener());
            this.lookupDimIDToRegisteredListener.add(event.world.field_73011_w.getDimension());
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(final AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("tropicraft", "PlayerDataInstance"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                PlayerDataInstance instance;
                {
                    this.instance = ((PlayerDataInstance)Tropicraft.PLAYER_DATA_INSTANCE.getDefaultInstance()).setPlayer((EntityPlayer)event.getObject());
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == Tropicraft.PLAYER_DATA_INSTANCE;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == Tropicraft.PLAYER_DATA_INSTANCE ? Tropicraft.PLAYER_DATA_INSTANCE.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)Tropicraft.PLAYER_DATA_INSTANCE.getStorage().writeNBT(Tropicraft.PLAYER_DATA_INSTANCE, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    Tropicraft.PLAYER_DATA_INSTANCE.getStorage().readNBT(Tropicraft.PLAYER_DATA_INSTANCE, (Object)this.instance, null, (NBTBase)nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public void onAttachCapabilitiesWorld(final AttachCapabilitiesEvent<World> event) {
        if (event.getObject() instanceof World) {
            event.addCapability(new ResourceLocation("tropicraft", "WorldDataInstance"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                WorldDataInstance instance;
                {
                    this.instance = ((WorldDataInstance)Tropicraft.WORLD_DATA_INSTANCE.getDefaultInstance()).setWorld((World)event.getObject());
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == Tropicraft.WORLD_DATA_INSTANCE;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == Tropicraft.WORLD_DATA_INSTANCE ? Tropicraft.WORLD_DATA_INSTANCE.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)Tropicraft.WORLD_DATA_INSTANCE.getStorage().writeNBT(Tropicraft.WORLD_DATA_INSTANCE, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    Tropicraft.WORLD_DATA_INSTANCE.getStorage().readNBT(Tropicraft.WORLD_DATA_INSTANCE, (Object)this.instance, null, (NBTBase)nbt);
                }
            });
        }
    }

    private boolean isSunset(World world) {
        long timeDay = world.func_72820_D() % 24000L;
        return timeDay > 12200L && timeDay < 14000L;
    }

    private void reset() {
        this.lookupDimIDToRegisteredListener.clear();
    }
}

