/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.event;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.config.TropicsConfigs;
import net.tropicraft.core.common.network.MessagePlayerSwimData;
import net.tropicraft.core.registry.ItemRegistry;

public class ScubaHandlerCommon {
    public static HashMap<UUID, MessagePlayerSwimData.PlayerSwimData> rotationMap = new HashMap();

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (!TropicsConfigs.enableSwimAnimation) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer && this.isInWater((EntityPlayer)event.getEntity()) && event.getSource().equals(DamageSource.field_76368_d)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTickPlayer(TickEvent.PlayerTickEvent event) {
        if (!TropicsConfigs.enableSwimAnimation) {
            return;
        }
        if (!event.type.equals((Object)TickEvent.Type.PLAYER)) {
            return;
        }
        EntityPlayer p = event.player;
        MessagePlayerSwimData.PlayerSwimData d = this.getData(p);
        boolean inLiquid = this.isInWater(p);
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            if (!inLiquid && d.targetHeight == d.currentHeight) {
                float f1;
                float f;
                if (p.func_184613_cA()) {
                    f = 0.6f;
                    f1 = 0.6f;
                } else if (p.func_70608_bn()) {
                    f = 0.2f;
                    f1 = 0.2f;
                } else if (p.func_70093_af()) {
                    f = 0.6f;
                    f1 = 1.65f;
                } else {
                    f = 0.6f;
                    f1 = 1.8f;
                }
                if (f != 0.3f || f1 != p.field_70131_O) {
                    AxisAlignedBB axisalignedbb = p.func_174813_aQ();
                    axisalignedbb = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)f, axisalignedbb.field_72338_b + (double)f1, axisalignedbb.field_72339_c + (double)f);
                    if (!p.field_70170_p.func_184143_b(axisalignedbb)) {
                        this.setPlayerSize(p, f, f1, 0.0f, f1);
                        d.currentHeight = f1;
                        d.targetHeight = f1;
                    }
                }
                return;
            }
            if (!this.isInWater(p, 0.0, -3.2, 0.0)) {
                if (!this.isPlayerWearingFlippers(p)) {
                    d.targetHeight = 1.8f;
                }
            } else {
                d.targetHeight = 1.1f;
            }
            if (!this.isInWater(p, 0.0, 1.8, 0.0)) {
                d.targetHeight = 1.8f;
            }
            if (d.currentHeight < d.targetHeight) {
                d.currentHeight += 0.1f;
                if (d.currentHeight > d.targetHeight) {
                    d.currentHeight = d.targetHeight;
                }
            }
            if (d.currentHeight > d.targetHeight) {
                d.currentHeight -= 0.1f;
                if (d.currentHeight < d.targetHeight) {
                    d.currentHeight = d.targetHeight;
                }
            }
            this.setPlayerSize(p, 0.6f, d.currentHeight, this.rangeMap(d.currentHeight, 0.6f, 1.8f, 1.25f, 0.0f), 1.0f);
        }
    }

    public void setPlayerSize(EntityPlayer p, float x, float y, float offset, float height) {
        AxisAlignedBB axisalignedbb = p.func_174813_aQ();
        p.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)x, axisalignedbb.field_72338_b + (double)y, axisalignedbb.field_72339_c + (double)x));
        if (Tropicraft.proxy.helloIsItMeYoureLookingFor(p)) {
            p.field_70163_u -= (double)offset;
        }
        p.field_70131_O = height;
    }

    public float lerp(float x1, float x2, float t) {
        float f = MathHelper.func_76142_g((float)(x2 - x1));
        if (f > t) {
            f = t;
        }
        if (f < -t) {
            f = -t;
        }
        return x1 + f;
    }

    public float rangeMap(float input, float inpMin, float inpMax, float outMin, float outMax) {
        if ((double)Math.abs(inpMax - inpMin) < 1.0E-12) {
            return 0.0f;
        }
        double ratio = (outMax - outMin) / (inpMax - inpMin);
        return (float)(ratio * (double)(input - inpMin) + (double)outMin);
    }

    public boolean isPlayerWearingFlippers(EntityPlayer p) {
        ItemStack bootSlot = (ItemStack)p.func_184193_aE().iterator().next();
        if (bootSlot != null) {
            return bootSlot.func_77973_b().equals(ItemRegistry.pinkFlippers) || bootSlot.func_77973_b().equals(ItemRegistry.yellowFlippers);
        }
        return false;
    }

    public boolean isInWater(EntityPlayer p, double offsetX, double offsetY, double offsetZ) {
        return p.field_70170_p.func_72875_a(p.func_174813_aQ().func_72317_d(offsetX, offsetY, offsetZ), Material.field_151586_h);
    }

    public boolean isInWater(EntityPlayer p) {
        return this.isInWater(p, 0.0, 0.0, 0.0);
    }

    private MessagePlayerSwimData.PlayerSwimData getData(EntityPlayer p) {
        if (!rotationMap.containsKey(p.func_110124_au())) {
            rotationMap.put(p.func_110124_au(), new MessagePlayerSwimData.PlayerSwimData(p.func_110124_au()));
        }
        return rotationMap.get(p.func_110124_au());
    }
}

