/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityTropicalFish;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class ItemFishBucket
extends ItemBucket {
    private static final String KEY_ENTITIES = "fishies";

    public ItemFishBucket() {
        super((Block)BlockRegistry.tropicsWater);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer playerIn, EnumHand hand) {
        RayTraceResult raytraceresult;
        ActionResult ret = super.func_77659_a(world, playerIn, hand);
        if (ret.func_188397_a() == EnumActionResult.SUCCESS && !world.field_72995_K && (raytraceresult = this.func_77621_a(world, playerIn, false)) != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = raytraceresult.func_178782_a();
            ItemStack stack = playerIn.func_184586_b(hand);
            for (EntityTropicalFish fish : ItemFishBucket.loadEntiesFromNBT(stack, world)) {
                fish.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)fish);
                fish.func_70642_aH();
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)(playerIn.field_71075_bZ.field_75098_d ? new ItemStack(ItemRegistry.tropicsWaterBucket) : new ItemStack(Items.field_151133_ar)));
        }
        return ret;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagList fishList = ItemFishBucket.getFishList(stack);
        TObjectIntHashMap fishCounts = new TObjectIntHashMap();
        for (int i = 0; i < fishList.func_74745_c(); ++i) {
            String color = EntityTropicalFish.NAMES[fishList.func_150305_b(i).func_74762_e("Color")];
            fishCounts.adjustOrPutValue((Object)color, 1, 1);
        }
        Iterator iterator = fishCounts.keySet().iterator();
        while (iterator.hasNext()) {
            String s;
            String line = s = (String)iterator.next();
            int count = fishCounts.get((Object)s);
            if (count > 1) {
                line = line + " (x" + count + ")";
            }
            tooltip.add(line);
        }
        super.func_77624_a(stack, world, tooltip, flagIn);
    }

    private static final NBTTagCompound getTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    private static final NBTTagList getFishList(ItemStack stack) {
        NBTTagCompound tag = ItemFishBucket.getTag(stack);
        if (!tag.func_74764_b(KEY_ENTITIES)) {
            tag.func_74782_a(KEY_ENTITIES, (NBTBase)new NBTTagList());
        }
        return tag.func_150295_c(KEY_ENTITIES, 10);
    }

    public static List<EntityTropicalFish> loadEntiesFromNBT(ItemStack stack, World world) {
        if (stack.func_190926_b()) {
            return new ArrayList<EntityTropicalFish>();
        }
        ArrayList<EntityTropicalFish> ret = new ArrayList<EntityTropicalFish>();
        NBTTagList entityTags = ItemFishBucket.getFishList(stack);
        for (int i = 0; i < entityTags.func_74745_c(); ++i) {
            ret.add((EntityTropicalFish)EntityList.func_75615_a((NBTTagCompound)entityTags.func_150305_b(i), (World)world));
        }
        return ret;
    }

    public static boolean addFish(ItemStack stack, EntityTropicalFish entity) {
        NBTTagList fishList;
        if (entity != null && (fishList = ItemFishBucket.getFishList(stack)).func_74745_c() < 5) {
            ItemFishBucket.getFishList(stack).func_74742_a((NBTBase)entity.serializeNBT());
            return true;
        }
        return false;
    }
}

