/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.client.entity.model.ModelScubaGear;
import net.tropicraft.core.common.item.armor.ItemTropicraftArmor;
import net.tropicraft.core.common.item.scuba.api.ScubaMaterial;
import net.tropicraft.core.registry.CreativeTabRegistry;
import net.tropicraft.core.registry.EntityRenderRegistry;

public abstract class ItemScubaGear
extends ItemTropicraftArmor {
    protected final ScubaMaterial scubaMaterial;
    protected boolean outOfArmorInventory = false;
    protected boolean hasCleanedUp = false;

    public ItemScubaGear(ItemArmor.ArmorMaterial material, ScubaMaterial scubaMaterial, int renderIndex, EntityEquipmentSlot slot) {
        super(material, renderIndex, slot);
        this.scubaMaterial = scubaMaterial;
        this.func_77637_a(CreativeTabRegistry.tropicraftTab);
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76369_e) {
            return new ISpecialArmor.ArmorProperties(10, 1.0, Integer.MAX_VALUE);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return ItemScubaGear.getArmorTexture(this.scubaMaterial).toString();
    }

    public static ResourceLocation getArmorTexture(ScubaMaterial material) {
        String color = material == ScubaMaterial.PINK ? "pink" : "yellow";
        return new ResourceLocation("tropicraft:textures/models/armor/scuba_gear_" + color + ".png");
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemstack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (itemstack.func_190926_b()) {
            return null;
        }
        ModelScubaGear armorModel = EntityRenderRegistry.getScubaModel(armorSlot);
        if (armorModel != null) {
            armorModel.field_78117_n = entityLiving.func_70093_af();
            armorModel.field_78093_q = entityLiving.func_184218_aH();
            armorModel.field_78091_s = entityLiving.func_70631_g_();
            armorModel.field_187076_m = entityLiving.func_184614_ca() != null ? ModelBiped.ArmPose.BLOCK : ModelBiped.ArmPose.EMPTY;
            return armorModel;
        }
        return null;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemstack) {
        this.hasCleanedUp = false;
        this.onScubaTick(world, player, itemstack);
    }

    protected abstract void onScubaTick(World var1, EntityPlayer var2, ItemStack var3);

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    protected abstract void onRemovedFromArmorInventory(World var1, EntityPlayer var2, ItemStack var3);
}

