/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba.api;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.tropicraft.core.common.item.scuba.ScubaCapabilities;
import net.tropicraft.core.common.item.scuba.api.IScubaTank;
import org.apache.commons.lang3.tuple.Pair;

public interface IScubaGear
extends IItemHandler,
INBTSerializable<NBTTagCompound> {
    public Pair<IScubaTank, IScubaTank> getTanks();

    default public float getTotalPressure() {
        Pair<IScubaTank, IScubaTank> tanks = this.getTanks();
        float pressure = 0.0f;
        if (tanks.getLeft() != null) {
            pressure += ((IScubaTank)tanks.getLeft()).getPressure();
        }
        if (tanks.getRight() != null) {
            pressure += ((IScubaTank)tanks.getRight()).getPressure();
        }
        return pressure;
    }

    @Nullable
    default public IScubaTank getFirstNonEmptyTank() {
        Pair<IScubaTank, IScubaTank> tanks = this.getTanks();
        return tanks.getLeft() == null || ((IScubaTank)tanks.getLeft()).getPressure() == 0.0f ? (IScubaTank)tanks.getRight() : (IScubaTank)tanks.getLeft();
    }

    default public void markDirty() {
    }

    default public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    default public void deserializeNBT(NBTTagCompound nbt) {
    }

    public static class ScubaGear
    extends ItemStackHandler
    implements IScubaGear {
        public ScubaGear() {
            super(2);
        }

        public void setSize(int size) {
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.markDirty();
        }

        @Override
        public Pair<IScubaTank, IScubaTank> getTanks() {
            return Pair.of((Object)this.getTank(this.getStackInSlot(0)), (Object)this.getTank(this.getStackInSlot(1)));
        }

        @Nullable
        private IScubaTank getTank(ItemStack stack) {
            return Optional.ofNullable(stack).map(s -> (IScubaTank)s.getCapability(ScubaCapabilities.getTankCapability(), null)).orElse(null);
        }
    }
}

