/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba.api;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.tropicraft.core.common.item.scuba.api.AirTypeRegistry;
import net.tropicraft.core.common.item.scuba.api.IAirType;
import org.apache.logging.log4j.LogManager;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface IScubaTank
extends INBTSerializable<NBTTagCompound> {
    public float getPressure();

    public void setPressure(float var1);

    public IAirType getAirType();

    public void setAirType(IAirType var1);

    default public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74776_a("pressure", this.getPressure());
        ret.func_74778_a("airType", this.getAirType().getID());
        return ret;
    }

    default public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        this.setPressure(nbt.func_74760_g("pressure"));
        IAirType type = AirTypeRegistry.INSTANCE.getType(nbt.func_74779_i("airType"));
        if (type == null) {
            LogManager.getLogger().error("Found invalid air type reading scuba tank NBT: {}", (Object)nbt.func_74779_i("airType"));
            type = IAirType.AirType.REGULAR;
        }
        this.setAirType(type);
    }

    public static class ScubaTank
    implements IScubaTank {
        private float pressure;
        @Nonnull
        private IAirType type = IAirType.AirType.REGULAR;

        @Override
        public float getPressure() {
            return this.pressure;
        }

        @Override
        public void setPressure(float pressure) {
            this.pressure = pressure;
        }

        @Override
        public IAirType getAirType() {
            return this.type;
        }

        @Override
        public void setAirType(IAirType type) {
            Preconditions.checkNotNull((Object)type);
            this.type = type;
        }
    }
}

