/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.network;

import com.google.common.base.Throwables;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class ThreadedNetworkWrapper {
    private final SimpleNetworkWrapper parent;

    public ThreadedNetworkWrapper(String channelName) {
        this.parent = new SimpleNetworkWrapper(channelName);
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, int discriminator, Side side) {
        this.registerMessage(ThreadedNetworkWrapper.instantiate(messageHandler), requestMessageType, discriminator, side);
    }

    static <REQ extends IMessage, REPLY extends IMessage> IMessageHandler<? super REQ, ? extends REPLY> instantiate(Class<? extends IMessageHandler<? super REQ, ? extends REPLY>> handler) {
        try {
            return handler.newInstance();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestMessageType, int discriminator, Side side) {
        this.parent.registerMessage(new Wrapper<REQ, REPLY>(messageHandler), requestMessageType, discriminator, side);
    }

    public Packet<?> getPacketFrom(IMessage message) {
        return this.parent.getPacketFrom(message);
    }

    public void sendToAll(IMessage message) {
        this.parent.sendToAll(message);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.parent.sendTo(message, player);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.parent.sendToAllAround(message, point);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.parent.sendToDimension(message, dimensionId);
    }

    public void sendToServer(IMessage message) {
        this.parent.sendToServer(message);
    }

    private final class Wrapper<REQ extends IMessage, REPLY extends IMessage>
    implements IMessageHandler<REQ, REPLY> {
        private final IMessageHandler<REQ, REPLY> wrapped;

        public Wrapper(IMessageHandler<REQ, REPLY> wrapped) {
            this.wrapped = wrapped;
        }

        public REPLY onMessage(REQ message, MessageContext ctx) {
            Minecraft target;
            Object object = target = ctx.side == Side.CLIENT ? Minecraft.func_71410_x() : FMLCommonHandler.instance().getMinecraftServerInstance();
            if (target != null) {
                target.func_152344_a((Runnable)new Runner(this, message, ctx));
            }
            return null;
        }

        public String toString() {
            return this.wrapped.toString();
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Wrapper) {
                return this.wrapped.equals(((Wrapper)obj).wrapped);
            }
            return this.wrapped.equals(obj);
        }

        private static final class Runner
        implements Runnable {
            private final REQ message;
            private final MessageContext ctx;
            final /* synthetic */ Wrapper this$1;

            public Runner(REQ message, MessageContext ctx) {
                this.this$1 = var1_1;
                this.message = message;
                this.ctx = ctx;
            }

            @Override
            public void run() {
                IMessage reply = this.this$1.wrapped.onMessage(this.message, this.ctx);
                if (reply != null) {
                    if (this.ctx.side == Side.CLIENT) {
                        this.this$1.ThreadedNetworkWrapper.this.sendToServer(reply);
                    } else {
                        EntityPlayerMP player = this.ctx.getServerHandler().field_147369_b;
                        if (player != null) {
                            this.this$1.ThreadedNetworkWrapper.this.sendTo(reply, player);
                        }
                    }
                }
            }
        }
    }
}

