/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.town;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.tropicraft.core.common.build.UtilBuild;
import net.tropicraft.core.common.town.ISimulationTickable;
import net.tropicraft.core.common.town.SpawnLocationData;

public class ManagedLocation
implements ISimulationTickable {
    public int locationID = -1;
    public int dimID;
    public BlockPos spawn;
    public boolean hasInit = false;
    public List<EntityLivingBase> listLoadedEntities = new ArrayList<EntityLivingBase>();
    public List<UUID> listPersistantEntities = new ArrayList<UUID>();
    public HashMap<UUID, Integer> lookupEntityToGender = new HashMap();
    public HashMap<Long, Object> lookupIDToTownObject = new HashMap();
    public int lastTownObjectIDSet = 1;
    public List<SpawnLocationData> listSpawnLocations = new ArrayList<SpawnLocationData>();
    public boolean respawnDeadEntities = false;
    public int minEntitiesToKeepAlive = 5;

    public void initData(int parLocation, int parDim, BlockPos parCoords) {
        this.locationID = parLocation;
        this.dimID = parDim;
        this.spawn = parCoords;
    }

    public void initFirstTime() {
    }

    @Override
    public BlockPos getOrigin() {
        return this.spawn;
    }

    @Override
    public void tickUpdate() {
        if (this.getWorld().func_82737_E() % 100L == 0L) {
            this.tickMonitorPersistantMembers(false);
        }
    }

    public World getWorld() {
        return DimensionManager.getWorld((int)this.dimID);
    }

    public void removeObject(Object obj) {
        if (obj instanceof EntityLivingBase) {
            this.listLoadedEntities.remove(obj);
        }
        if (!(obj instanceof EntityLivingBase)) {
            this.lookupIDToTownObject.remove(obj);
        }
    }

    public void hookEntityDied(EntityLivingBase ent) {
        this.removeObject(ent);
        this.listPersistantEntities.remove(ent.getPersistentID());
    }

    public void hookEntityDestroyed(EntityLivingBase ent) {
        this.removeObject(ent);
    }

    public void addEntity(EntityLivingBase ent) {
        if (this.listLoadedEntities.contains(ent)) {
            UtilBuild.dbg("WARNING: adding already existing entity to ManagedLocation");
        } else {
            this.listLoadedEntities.add(ent);
        }
        if (this.listPersistantEntities.contains(ent.getPersistentID())) {
            UtilBuild.dbg("WARNING: adding already existing entitys _persistant ID_ to ManagedLocation");
        } else {
            this.listPersistantEntities.add(ent.getPersistentID());
        }
    }

    public void registerSpawnLocation(SpawnLocationData parData) {
        this.listSpawnLocations.add(parData);
    }

    public void registerSpawnLocation(BlockPos parCoords, String ... types) {
        for (int i = 0; i < types.length; ++i) {
            this.listSpawnLocations.add(new SpawnLocationData(parCoords, types[i]));
        }
    }

    public void tickMonitorPersistantMembers(boolean initialSpawn) {
        if (this.respawnDeadEntities || initialSpawn || this.minEntitiesToKeepAlive > 0 && this.listPersistantEntities.size() < this.minEntitiesToKeepAlive && this.listSpawnLocations.size() >= this.minEntitiesToKeepAlive) {
            for (int i = 0; i < this.listSpawnLocations.size(); ++i) {
                SpawnLocationData data = this.listSpawnLocations.get(i);
                if (data.entityUUID != null && !this.listPersistantEntities.contains(data.entityUUID)) {
                    data.entityUUID = null;
                }
                if (data.entityUUID == null) {
                    EntityLivingBase ent = this.spawnMemberAtSpawnLocation(data);
                    if (data.entityUUID == null) {
                        // empty if block
                    }
                }
                if (!this.respawnDeadEntities && !initialSpawn && this.listPersistantEntities.size() >= this.minEntitiesToKeepAlive) break;
            }
        }
    }

    public EntityLivingBase spawnMemberAtSpawnLocation(SpawnLocationData parData) {
        return null;
    }

    @Override
    public void cleanup() {
        this.listLoadedEntities.clear();
        this.listPersistantEntities.clear();
        this.lookupIDToTownObject.clear();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound var1) {
        var1.func_74778_a("classname", this.getClass().getCanonicalName());
        var1.func_74768_a("locationID", this.locationID);
        var1.func_74768_a("dimID", this.dimID);
        var1.func_74768_a("minEntitiesToKeepAlive", this.minEntitiesToKeepAlive);
        UtilBuild.writeCoords("spawn", this.spawn, var1);
        NBTTagCompound nbtListPersistantEntities = new NBTTagCompound();
        int count = 0;
        for (int i = 0; i < this.listPersistantEntities.size(); ++i) {
            NBTTagCompound nbtEntry = new NBTTagCompound();
            nbtEntry.func_74778_a("UUID", this.listPersistantEntities.get(i).toString());
            nbtListPersistantEntities.func_74782_a("entry_" + count++, (NBTBase)nbtEntry);
        }
        var1.func_74782_a("listPersistantEntities", (NBTBase)nbtListPersistantEntities);
        return var1;
    }

    @Override
    public void readFromNBT(NBTTagCompound var1) {
        this.hasInit = true;
        this.locationID = var1.func_74762_e("locationID");
        this.dimID = var1.func_74762_e("dimID");
        if (var1.func_74764_b("minEntitiesToKeepAlive")) {
            this.minEntitiesToKeepAlive = var1.func_74762_e("minEntitiesToKeepAlive");
        }
        this.spawn = UtilBuild.readCoords("spawn", var1);
        NBTTagCompound nbtPersistantEntities = var1.func_74775_l("listPersistantEntities");
        for (String entryName : nbtPersistantEntities.func_150296_c()) {
            NBTTagCompound entry = nbtPersistantEntities.func_74775_l(entryName);
            UUID uuid = UUID.fromString(entry.func_74779_i("UUID"));
            this.listPersistantEntities.add(uuid);
        }
    }

    @Override
    public boolean isThreaded() {
        return false;
    }

    @Override
    public void tickUpdateThreaded() {
    }

    @Override
    public String getSharedSimulationName() {
        return "";
    }

    @Override
    public void init() {
    }

    @Override
    public void initPost() {
    }

    public int getPopulationSize() {
        return this.listPersistantEntities.size();
    }
}

