/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tropicraft.core.common.worldgen.TCGenBase;

public abstract class TCDirectionalGen
extends TCGenBase {
    public static final int Z_PLUS = 0;
    public static final int Z_MINUS = 1;
    public static final int X_PLUS = 2;
    public static final int X_MINUS = 3;
    public int originX;
    public int originZ;
    public int dir;

    public TCDirectionalGen(World world, Random rand) {
        super(world, rand);
    }

    public TCDirectionalGen(World world, Random rand, int dir) {
        super(world, rand);
        this.dir = dir;
    }

    public void setOrigin(int originX, int originZ) {
        this.originX = originX;
        this.originZ = originZ;
    }

    public void setDir(int dir) {
        this.dir = dir;
    }

    public Block getBlockWithDir(int x, int y, int z) {
        return this.getBlockWithDir(new BlockPos(x, y, z));
    }

    public Block getBlockWithDir(BlockPos pos) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        switch (this.dir) {
            case 2: {
                return this.worldObj.func_180495_p(this.pos(this.originX + i, j, this.originZ + k)).func_177230_c();
            }
            case 0: {
                return this.worldObj.func_180495_p(this.pos(this.originX + k, j, this.originZ - i)).func_177230_c();
            }
            case 3: {
                return this.worldObj.func_180495_p(this.pos(this.originX - i, j, this.originZ - k)).func_177230_c();
            }
            case 1: {
                return this.worldObj.func_180495_p(this.pos(this.originX - k, j, this.originZ + i)).func_177230_c();
            }
        }
        return null;
    }

    public void placeBlockWithDir(int x, int y, int z, IBlockState state) {
        switch (this.dir) {
            case 2: {
                this.worldObj.func_180501_a(this.pos(this.originX + x, y, this.originZ + z), state, blockGenNotifyFlag);
                return;
            }
            case 0: {
                this.worldObj.func_180501_a(this.pos(this.originX + z, y, this.originZ - x), state, blockGenNotifyFlag);
                return;
            }
            case 3: {
                this.worldObj.func_180501_a(this.pos(this.originX - x, y, this.originZ - z), state, blockGenNotifyFlag);
                return;
            }
            case 1: {
                this.worldObj.func_180501_a(this.pos(this.originX - z, y, this.originZ + x), state, blockGenNotifyFlag);
                return;
            }
        }
    }

    public void placeBlockWithDir(BlockPos pos, IBlockState state) {
        this.placeBlockWithDir(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), state);
    }

    public TileEntity getTEWithDir(BlockPos pos) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        switch (this.dir) {
            case 2: {
                return this.worldObj.func_175625_s(this.pos(this.originX + i, j, this.originZ + k));
            }
            case 0: {
                return this.worldObj.func_175625_s(this.pos(this.originX + k, j, this.originZ - i));
            }
            case 3: {
                return this.worldObj.func_175625_s(this.pos(this.originX - i, j, this.originZ - k));
            }
            case 1: {
                return this.worldObj.func_175625_s(this.pos(this.originX - k, j, this.originZ + i));
            }
        }
        return null;
    }

    public int getTerrainHeightWithDir(int i, int k) {
        switch (this.dir) {
            case 2: {
                return this.getTerrainHeightAt(this.originX + i, this.originZ + k);
            }
            case 0: {
                return this.getTerrainHeightAt(this.originX + k, this.originZ - i);
            }
            case 3: {
                return this.getTerrainHeightAt(this.originX - i, this.originZ - k);
            }
            case 1: {
                return this.getTerrainHeightAt(this.originX - k, this.originZ + i);
            }
        }
        return 64;
    }

    public int getActualXAt(int i, int k) {
        switch (this.dir) {
            case 2: {
                return this.originX + i;
            }
            case 0: {
                return this.originX + k;
            }
            case 3: {
                return this.originX - i;
            }
            case 1: {
                return this.originX - k;
            }
        }
        return this.originX;
    }

    public int getActualZAt(int i, int k) {
        switch (this.dir) {
            case 2: {
                return this.originZ + k;
            }
            case 0: {
                return this.originZ - i;
            }
            case 3: {
                return this.originZ - k;
            }
            case 1: {
                return this.originZ + i;
            }
        }
        return this.originZ;
    }

    public BlockPos pos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }
}

