/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TCGenUtils {
    public static BlockPos getBlockPos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    public static BlockPos getBlockPos(int[] xyz) {
        return new BlockPos(xyz[0], xyz[1], xyz[2]);
    }

    public static Block getBlock(IBlockAccess world, int x, int y, int z) {
        return TCGenUtils.getBlock(world, TCGenUtils.getBlockPos(x, y, z));
    }

    public static Block getBlock(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }

    public static IBlockState getBlockState(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    public static IBlockState getBlockState(IBlockAccess world, int x, int y, int z) {
        return TCGenUtils.getBlockState(world, TCGenUtils.getBlockPos(x, y, z));
    }

    public static boolean isAirBlock(IBlockAccess world, int x, int y, int z) {
        return TCGenUtils.isAirBlock(world, TCGenUtils.getBlockPos(x, y, z));
    }

    public static boolean isAirBlock(IBlockAccess world, BlockPos pos) {
        return world.func_175623_d(pos);
    }

    public static boolean setBlock(World world, BlockPos pos, Block block) {
        return world.func_175656_a(pos, block.func_176223_P());
    }

    public static boolean setBlock(World world, int x, int y, int z, Block block) {
        return TCGenUtils.setBlock(world, new BlockPos(x, y, z), block);
    }

    public static boolean setBlockState(World world, BlockPos pos, IBlockState state, int flags) {
        return world.func_180501_a(pos, state, flags);
    }

    public static boolean setBlockState(World world, BlockPos pos, IBlockState state) {
        return world.func_175656_a(pos, state);
    }

    public static boolean setBlockState(World world, int x, int y, int z, IBlockState state) {
        return TCGenUtils.setBlockState(world, new BlockPos(x, y, z), state);
    }

    public static boolean setBlockState(World world, int x, int y, int z, IBlockState state, int flags) {
        return world.func_180501_a(new BlockPos(x, y, z), state, flags);
    }

    public static Material getMaterial(IBlockAccess world, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x, y, z)).func_185904_a();
    }

    public static Material getMaterial(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a();
    }

    public static boolean isBlockInList(Block block1, Block ... blocks) {
        for (Block b : blocks) {
            if (block1 != b) continue;
            return true;
        }
        return false;
    }
}

