/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.BlockCoffeeBush;
import net.tropicraft.core.common.worldgen.TCGenBase;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;

public class WorldGenCoffeePlant
extends TCGenBase {
    private static final EnumFacing[] cardinalDirections = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};

    public WorldGenCoffeePlant(World world, Random rand) {
        super(world, rand);
    }

    @Override
    public boolean generate(BlockPos pos) {
        int neighborz;
        int neighborx;
        int nz;
        int ny;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int nx = x + this.rand.nextInt(8) - this.rand.nextInt(8);
        if (!TCGenUtils.isAirBlock((IBlockAccess)this.worldObj, nx, ny = y, nz = z + this.rand.nextInt(8) - this.rand.nextInt(8)) || TCGenUtils.getBlock((IBlockAccess)this.worldObj, nx, ny - 1, nz) != Blocks.field_150349_c) {
            return false;
        }
        EnumFacing viableDirection = null;
        for (EnumFacing dir : cardinalDirections) {
            neighborx = nx + dir.func_82601_c();
            if (TCGenUtils.getMaterial((IBlockAccess)this.worldObj, neighborx, ny - 1, neighborz = nz + dir.func_82599_e()) != Material.field_151586_h) continue;
            viableDirection = dir;
            break;
        }
        if (viableDirection == null) {
            for (EnumFacing dir : cardinalDirections) {
                neighborx = nx + dir.func_82601_c();
                if (!TCGenUtils.isAirBlock((IBlockAccess)this.worldObj, neighborx, ny, neighborz = nz + dir.func_82599_e()) || TCGenUtils.getBlock((IBlockAccess)this.worldObj, neighborx, ny - 1, neighborz) != Blocks.field_150349_c || TCGenUtils.isAirBlock((IBlockAccess)this.worldObj, neighborx, ny - 2, neighborz)) continue;
                boolean surrounded = true;
                for (EnumFacing surroundingDir : cardinalDirections) {
                    int surroundingz;
                    int surroundingx = neighborx + surroundingDir.func_82601_c();
                    if (TCGenUtils.isAirBlock((IBlockAccess)this.worldObj, surroundingx, ny, surroundingz = neighborz + surroundingDir.func_82599_e()) && TCGenUtils.getBlock((IBlockAccess)this.worldObj, surroundingx, ny - 1, surroundingz) == Blocks.field_150349_c) continue;
                    surrounded = false;
                    break;
                }
                if (!surrounded) continue;
                viableDirection = dir;
                break;
            }
        }
        if (viableDirection == null) {
            return false;
        }
        TCGenUtils.setBlockState(this.worldObj, nx + viableDirection.func_82601_c(), ny - 1, nz + viableDirection.func_82599_e(), Blocks.field_150355_j.func_176223_P(), blockGenNotifyFlag);
        TCGenUtils.setBlockState(this.worldObj, nx, ny - 1, nz, Blocks.field_150458_ak.func_176223_P(), blockGenNotifyFlag);
        for (int i = 0; i < 3 && TCGenUtils.isAirBlock((IBlockAccess)this.worldObj, nx, ny + i, nz); ++i) {
            TCGenUtils.setBlockState(this.worldObj, nx, ny + i, nz, BlockRegistry.coffeePlant.func_176223_P().func_177226_a((IProperty)BlockCoffeeBush.AGE, (Comparable)Integer.valueOf(6)), blockGenNotifyFlag);
        }
        return true;
    }
}

