/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.BlockFruitLeaves;
import net.tropicraft.core.common.block.BlockTropicraftLeaves;
import net.tropicraft.core.common.enums.TropicraftFruitLeaves;
import net.tropicraft.core.common.enums.TropicraftLeaves;
import net.tropicraft.core.common.worldgen.TCGenBase;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;

public class WorldGenFruitTrees
extends TCGenBase {
    private final IBlockState WOOD_BLOCK = Blocks.field_150364_r.func_176223_P();
    private final IBlockState REGULAR_LEAF_BLOCK = BlockRegistry.leaves.func_176223_P().func_177226_a(BlockTropicraftLeaves.VARIANT, (Comparable)((Object)TropicraftLeaves.FRUIT));
    private final IBlockState FRUIT_LEAF_BLOCK;
    int treeType;

    public WorldGenFruitTrees(World world, Random rand, int type) {
        super(world, rand);
        this.treeType = type;
        this.FRUIT_LEAF_BLOCK = BlockRegistry.fruitLeaves.func_176223_P().func_177226_a(BlockFruitLeaves.VARIANT, (Comparable)((Object)TropicraftFruitLeaves.byMetadata(type)));
    }

    @Override
    public boolean generate(BlockPos pos) {
        int y;
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        int height = this.rand.nextInt(3) + 4;
        boolean canGenerate = true;
        if (j < 1 || j + height + 1 > this.worldObj.func_72800_K()) {
            return false;
        }
        for (int y2 = j; y2 <= j + 1 + height; ++y2) {
            int size = 1;
            if (y2 == j) {
                size = 0;
            }
            if (y2 >= j + 1 + height - 2) {
                size = 2;
            }
            for (int x = i - size; x <= i + size && canGenerate; ++x) {
                for (int z = k - size; z <= k + size && canGenerate; ++z) {
                    if (y2 >= 0 && y2 < this.worldObj.func_72800_K()) {
                        Block block = TCGenUtils.getBlock((IBlockAccess)this.worldObj, x, y2, z);
                        if (TCGenUtils.isBlockInList(block, Blocks.field_150350_a, this.FRUIT_LEAF_BLOCK.func_177230_c())) continue;
                        canGenerate = false;
                        continue;
                    }
                    canGenerate = false;
                }
            }
        }
        if (!canGenerate) {
            return false;
        }
        Block blockUnder = TCGenUtils.getBlock((IBlockAccess)this.worldObj, i, j - 1, k);
        if (blockUnder != Blocks.field_150349_c && blockUnder != Blocks.field_150346_d || j >= this.worldObj.func_72800_K() - height - 1) {
            return false;
        }
        TCGenUtils.setBlockState(this.worldObj, i, j - 1, k, Blocks.field_150346_d.func_176223_P(), blockGenNotifyFlag);
        for (y = j - 3 + height; y <= j + height; ++y) {
            int presizeMod = y - (j + height);
            int size = 1 - presizeMod / 2;
            for (int x = i - size; x <= i + size; ++x) {
                int localX = x - i;
                for (int z = k - size; z <= k + size; ++z) {
                    int localZ = z - k;
                    if (Math.abs(localX) == size && Math.abs(localZ) == size && (this.rand.nextInt(2) == 0 || presizeMod == 0) || TCGenUtils.getBlockState((IBlockAccess)this.worldObj, x, y, z).func_185914_p()) continue;
                    if (this.rand.nextBoolean()) {
                        TCGenUtils.setBlockState(this.worldObj, x, y, z, this.FRUIT_LEAF_BLOCK, blockGenNotifyFlag);
                        continue;
                    }
                    TCGenUtils.setBlockState(this.worldObj, x, y, z, this.REGULAR_LEAF_BLOCK, blockGenNotifyFlag);
                }
            }
        }
        for (y = 0; y < height; ++y) {
            Block k2 = TCGenUtils.getBlock((IBlockAccess)this.worldObj, i, j + y, k);
            if (k2 != Blocks.field_150350_a && k2.func_176223_P().func_185904_a() != Material.field_151584_j) continue;
            TCGenUtils.setBlockState(this.worldObj, i, j + y, k, this.WOOD_BLOCK, blockGenNotifyFlag);
        }
        return true;
    }
}

