/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.BlockTropicraftLeaves;
import net.tropicraft.core.common.block.BlockTropicraftLog;
import net.tropicraft.core.common.enums.TropicraftLeaves;
import net.tropicraft.core.common.enums.TropicraftLogs;
import net.tropicraft.core.common.worldgen.TCGenBase;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;

public class WorldGenNormalPalms
extends TCGenBase {
    private static final IBlockState palmWood = BlockRegistry.logs.func_176223_P().func_177226_a(BlockTropicraftLog.VARIANT, (Comparable)((Object)TropicraftLogs.PALM));
    private static final IBlockState palmLeaves = BlockRegistry.leaves.func_176223_P().func_177226_a(BlockTropicraftLeaves.VARIANT, (Comparable)((Object)TropicraftLeaves.PALM));

    public WorldGenNormalPalms(World world, Random random) {
        super(world, random);
    }

    @Override
    public boolean generate(BlockPos pos) {
        if (TCGenUtils.getBlockState((IBlockAccess)this.worldObj, pos.func_177977_b()).func_185904_a() != Material.field_151595_p) {
            return false;
        }
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        byte height = (byte)(this.rand.nextInt(4) + 6);
        boolean canGen = true;
        if (j < 1 || j + height + 1 > 256) {
            return false;
        }
        for (int l = j; l <= j + 1 + height; ++l) {
            int byte1 = 1;
            if (l == j) {
                byte1 = 0;
            }
            if (l >= j + 1 + height - 2) {
                byte1 = 2;
            }
            for (int j1 = i - byte1; j1 <= i + byte1 && canGen; ++j1) {
                for (int k1 = k - byte1; k1 <= k + byte1 && canGen; ++k1) {
                    if (l >= 0 && l < 256) {
                        Block l1 = TCGenUtils.getBlock((IBlockAccess)this.worldObj, j1, l, k1);
                        if (l1 == Blocks.field_150350_a || l1 == BlockRegistry.leaves) continue;
                        canGen = false;
                        continue;
                    }
                    canGen = false;
                }
            }
        }
        if (!canGen) {
            return false;
        }
        Material matBelow = TCGenUtils.getMaterial((IBlockAccess)this.worldObj, i, j - 1, k);
        if (matBelow != Material.field_151595_p || j >= 256 - height - 1) {
            int ground = this.getHeight(i, k);
            matBelow = TCGenUtils.getMaterial((IBlockAccess)this.worldObj, i, ground - 1, k);
            if (matBelow != Material.field_151595_p || j >= 256 - height - 1) {
                return false;
            }
            j = ground;
        }
        TCGenUtils.setBlockState(this.worldObj, i, j + height + 2, k, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i, j + height + 1, k + 1, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i, j + height + 1, k + 2, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i, j + height + 1, k + 3, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i, j + height, k + 4, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i + 1, j + height + 1, k, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i + 2, j + height + 1, k, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i + 3, j + height + 1, k, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i + 4, j + height, k, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i, j + height + 1, k - 1, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i, j + height + 1, k - 2, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i, j + height + 1, k - 3, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i, j + height, k - 4, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i - 1, j + height + 1, k, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i - 1, j + height + 1, k - 1, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i - 1, j + height + 1, k + 1, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i + 1, j + height + 1, k - 1, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i + 1, j + height + 1, k + 1, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i - 2, j + height + 1, k, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i - 3, j + height + 1, k, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i - 4, j + height, k, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i + 2, j + height + 1, k + 2, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i + 2, j + height + 1, k - 2, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i - 2, j + height + 1, k + 2, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i - 2, j + height + 1, k - 2, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i + 3, j + height, k + 3, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i + 3, j + height, k - 3, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i - 3, j + height, k + 3, palmLeaves);
        TCGenUtils.setBlockState(this.worldObj, i - 3, j + height, k - 3, palmLeaves);
        for (int j1 = 0; j1 < height + 4; ++j1) {
            Block l1 = TCGenUtils.getBlock((IBlockAccess)this.worldObj, i, j + j1, k);
            if (!TCGenUtils.isAirBlock((IBlockAccess)this.worldObj, i, j + j1, k) && l1 != palmLeaves.func_177230_c()) continue;
            TCGenUtils.setBlockState(this.worldObj, i, j + j1 - 2, k, palmWood);
            BlockPos pos3 = new BlockPos(i, j + j1 - 2, k);
            BlockTropicraftLog.spawnCoconuts(this.worldObj, pos3, this.rand, 2);
            if (j1 > height - 1 && j1 < height + 2) continue;
        }
        return true;
    }
}

