/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen.genlayer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.tropicraft.core.common.worldgen.genlayer.GenLayerTropicraft;
import net.tropicraft.core.common.worldgen.genlayer.GenLayerTropicraftAddSubBiomes;

public class GenLayerTropicraftAddWeightedSubBiomes
extends GenLayerTropicraftAddSubBiomes {
    private final List<WeightedRandom.Item> biomeWeights;
    private final int totalWeight;
    private TObjectIntMap<WeightedRandom.Item> biomeLookup = new TObjectIntHashMap();

    public GenLayerTropicraftAddWeightedSubBiomes(long seed, GenLayerTropicraft parent, int baseID, int[] biomes, WeightedRandom.Item ... weights) {
        super(seed, parent, baseID, new int[0]);
        Preconditions.checkArgument((biomes.length == weights.length ? 1 : 0) != 0, (Object)"Must provide as many weights as there are biomes!");
        this.biomeWeights = Lists.newArrayList((Object[])weights);
        this.totalWeight = WeightedRandom.func_76272_a(this.biomeWeights);
        for (int i = 0; i < weights.length; ++i) {
            this.biomeLookup.put((Object)weights[i], biomes[i]);
        }
    }

    @Override
    protected int getSubBiome(int id) {
        return this.biomeLookup.get((Object)WeightedRandom.func_180166_a(this.biomeWeights, (int)this.func_75902_a(this.totalWeight)));
    }

    public void func_75903_a(long p_75903_1_, long p_75903_3_) {
        super.func_75903_a(p_75903_1_ >> 1, p_75903_3_ >> 1);
    }
}

