/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.proxy;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.PlayerSwimDataClientHandler;
import net.tropicraft.core.client.ScubaHandler;
import net.tropicraft.core.client.ScubaOverlayHandler;
import net.tropicraft.core.client.TropicraftLoadingListener;
import net.tropicraft.core.client.TropicraftWaterRenderFixer;
import net.tropicraft.core.common.block.BlockTropicraftFence;
import net.tropicraft.core.common.block.ITropicraftBlock;
import net.tropicraft.core.common.block.tileentity.TileEntityAirCompressor;
import net.tropicraft.core.common.block.tileentity.TileEntityDrinkMixer;
import net.tropicraft.core.common.item.IColoredItem;
import net.tropicraft.core.common.network.MessagePlayerSwimData;
import net.tropicraft.core.common.network.TCPacketHandler;
import net.tropicraft.core.encyclopedia.TropicalBook;
import net.tropicraft.core.proxy.CommonProxy;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.EncyclopediaRegistry;
import net.tropicraft.core.registry.EntityRenderRegistry;
import net.tropicraft.core.registry.ItemRegistry;
import net.tropicraft.core.registry.TileEntityRenderRegistry;

public class ClientProxy
extends CommonProxy {
    private final Map<Block, IStateMapper> stateMappers = new HashMap<Block, IStateMapper>();
    private final Map<String, String[]> blockVariants = new HashMap<String, String[]>();

    public ClientProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void preInit() {
        super.preInit();
    }

    @SubscribeEvent
    public void registerStateMappers(ModelRegistryEvent event) {
        this.ignoreProperties(BlockRegistry.coral, new IProperty[]{BlockFluidBase.LEVEL});
        this.ignoreProperties((Block)BlockRegistry.bambooFenceGate, new IProperty[]{BlockFenceGate.field_176465_b});
        this.ignoreProperties((Block)BlockRegistry.chunkFenceGate, new IProperty[]{BlockFenceGate.field_176465_b});
        this.ignoreProperties((Block)BlockRegistry.mahoganyFenceGate, new IProperty[]{BlockFenceGate.field_176465_b});
        this.ignoreProperties((Block)BlockRegistry.palmFenceGate, new IProperty[]{BlockFenceGate.field_176465_b});
        this.ignoreProperties((Block)BlockRegistry.thatchFenceGate, new IProperty[]{BlockFenceGate.field_176465_b});
        this.ignoreAll(BlockRegistry.bambooFence, BlockRegistry.chunkFence, BlockRegistry.mahoganyFence, BlockRegistry.palmFence, BlockRegistry.thatchFence);
    }

    @Override
    public void init() {
        super.init();
        ItemRegistry.clientProxyInit();
        BlockRegistry.clientProxyInit();
        EntityRenderRegistry.init();
        TileEntityRenderRegistry.init();
        MinecraftForge.EVENT_BUS.register((Object)new TropicraftWaterRenderFixer());
        MinecraftForge.EVENT_BUS.register((Object)new ScubaHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ScubaOverlayHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TropicraftLoadingListener());
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)BlockRegistry.drinkMixer), (int)0, TileEntityDrinkMixer.class);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)BlockRegistry.airCompressor), (int)0, TileEntityAirCompressor.class);
    }

    private void ignoreAll(Block ... blocks) {
        for (Block block : blocks) {
            this.ignoreProperties(block, block.func_176194_O().func_177623_d().toArray(new IProperty[0]));
        }
    }

    private void ignoreProperties(@Nonnull Block block, IProperty<?> ... props) {
        this.setStateMapper(block, (IStateMapper)new StateMap.Builder().func_178442_a(props).func_178441_a());
    }

    private void setStateMapper(@Nonnull Block block, @Nonnull IStateMapper mapper) {
        this.stateMappers.put(block, mapper);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    @Override
    public void registerColoredBlock(Block block) {
        ITropicraftBlock tcBlock = (ITropicraftBlock)block;
        if (tcBlock.getBlockColor() != null) {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(tcBlock.getBlockColor(), new Block[]{block});
        }
        if (tcBlock.getItemColor() != null) {
            Minecraft.func_71410_x().getItemColors().func_186731_a(tcBlock.getItemColor(), new Block[]{block});
        }
    }

    @Override
    public <T extends Item> void registerColoredItem(T item) {
        IItemColor itemColor = ((IColoredItem)item).getColorHandler();
        if (itemColor != null) {
            Minecraft.func_71410_x().getItemColors().func_186730_a(itemColor, new Item[]{item});
        } else {
            System.err.println("!!! FAILED TO REGISTER COLOR HANDLER FOR ITEM " + item.func_77658_a() + " !!!");
        }
    }

    public void registerItemRender(Item item, int meta, String unlocalizedName) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, new ModelResourceLocation("tropicraft:" + unlocalizedName, "inventory"));
    }

    public void registerItemRender(Item item, int meta, String unlocalizedName, String location) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "variant=" + unlocalizedName));
    }

    @Override
    public void registerItemVariantModel(Item item, String name, int metadata) {
        this.registerItemVariantModel(item, name, metadata, "inventory");
    }

    @Override
    public void registerItemVariantModel(Item item, String name, int metadata, String variant) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation("tropicraft:" + name, variant));
        }
    }

    private Map<IBlockState, ModelResourceLocation> getStates(Block block) {
        return this.stateMappers.getOrDefault(block, (IStateMapper)new DefaultStateMapper()).func_178130_a(block);
    }

    @Override
    public void registerBlockVariantModels(Block block, Item item) {
        for (Map.Entry<IBlockState, ModelResourceLocation> e : this.getStates(block).entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)block.func_176201_c(e.getKey()), (ModelResourceLocation)e.getValue());
        }
    }

    @Override
    public void registerBlockVariantModel(IBlockState state, Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getStates(state.func_177230_c()).get(state));
    }

    @Override
    public void registerArbitraryBlockVariants(String name, String ... variants) {
        this.blockVariants.put(name, variants);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        for (Map.Entry<String, String[]> e : this.blockVariants.entrySet()) {
            for (String variant : e.getValue()) {
                ModelResourceLocation loc = new ModelResourceLocation("tropicraft:" + e.getKey(), variant);
                IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)loc, (String)("Could not load arbitrary block variant " + variant + " for block " + e.getKey()));
                event.getModelRegistry().func_82595_a((Object)loc, (Object)model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter()));
            }
        }
        try {
            Block[] fences;
            IModel waterTop = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("tropicraft:block/tropics_water_top"));
            final IBakedModel waterTopBaked = waterTop.bake(waterTop.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
            for (Block block : fences = new Block[]{BlockRegistry.bambooFence, BlockRegistry.chunkFence, BlockRegistry.mahoganyFence, BlockRegistry.palmFence, BlockRegistry.thatchFence}) {
                ModelResourceLocation loc = new ModelResourceLocation(block.getRegistryName(), "normal");
                final IBakedModel fenceModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)loc);
                event.getModelRegistry().func_82595_a((Object)loc, (Object)new IBakedModel(){

                    @Nonnull
                    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
                        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
                        if (layer == null || layer == BlockRenderLayer.SOLID) {
                            return fenceModel.func_188616_a(state, side, rand);
                        }
                        if (layer == BlockRenderLayer.TRANSLUCENT && state.func_177229_b(BlockTropicraftFence.WATER) == BlockTropicraftFence.WaterState.SURFACE) {
                            return waterTopBaked.func_188616_a(state, side, rand);
                        }
                        return Collections.emptyList();
                    }

                    public boolean func_177556_c() {
                        return true;
                    }

                    public boolean func_188618_c() {
                        return false;
                    }

                    public boolean func_177555_b() {
                        return true;
                    }

                    @Nonnull
                    public TextureAtlasSprite func_177554_e() {
                        return fenceModel.func_177554_e();
                    }

                    @Nonnull
                    public ItemOverrideList func_188617_f() {
                        return fenceModel.func_188617_f();
                    }
                });
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void registerItemWithSubtypes(Item item, CreativeTabs tab) {
        if (item.func_77614_k()) {
            NonNullList subItems = NonNullList.func_191196_a();
            item.func_150895_a(tab, subItems);
            for (ItemStack subItem : subItems) {
                String subItemName = item.func_77667_c(subItem);
                subItemName = subItemName.substring(subItemName.indexOf(".") + 1);
                this.registerItemVariantModel(item, subItemName, subItem.func_77960_j());
            }
        } else {
            this.registerItemVariantModel(item, item.delegate.name().func_110623_a(), 0);
        }
    }

    @Override
    public void registerFluidBlockRendering(Block block, String name) {
        final ModelResourceLocation fluidLocation = new ModelResourceLocation("tropicraft:" + name, "normal");
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            @Nonnull
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidLocation;
            }
        });
    }

    @Override
    public void registerBooks() {
        Tropicraft.encyclopedia = new TropicalBook("etsave.dat", "encyclopedia_tropica", "encyclopedia_tropica_inside");
        EncyclopediaRegistry.init();
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void registerClientPacketScuba() {
        super.registerClientPacketScuba();
        TCPacketHandler.INSTANCE.registerMessage(PlayerSwimDataClientHandler.class, MessagePlayerSwimData.class, 4, Side.CLIENT);
    }

    @Override
    public boolean helloIsItMeYoureLookingFor(EntityPlayer player) {
        return player == Minecraft.func_71410_x().field_71439_g;
    }
}

