/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.entity.passive.EntityTFPenguin;
import twilightforest.potions.TFPotions;
import twilightforest.world.feature.TFGenPenguins;

public class TFBiomeGlacier
extends TFBiomeBase {
    public TFBiomeGlacier(Biome.BiomeProperties props) {
        super(props);
        this.getTFBiomeDecorator().setTreesPerChunk(1);
        this.getTFBiomeDecorator().setGrassPerChunk(0);
        this.getTFBiomeDecorator().hasCanopy = false;
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFPenguin.class, 10, 4, 4));
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(3) == 0) {
            return new WorldGenTaiga1();
        }
        return new WorldGenTaiga2(true);
    }

    public boolean func_76746_c() {
        return true;
    }

    public boolean func_76738_d() {
        return false;
    }

    public void func_180624_a(World world, Random random, BlockPos pos) {
        super.func_180624_a(world, random, pos);
        TFGenPenguins penguins = new TFGenPenguins();
        if (random.nextInt(4) == 0) {
            int x = pos.func_177958_n() + random.nextInt(16) + 8;
            int y = 31;
            int z = pos.func_177952_p() + random.nextInt(16) + 8;
            penguins.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    @Override
    protected ResourceLocation[] getRequiredAdvancements() {
        return new ResourceLocation[]{TwilightForestMod.prefix("progress_yeti")};
    }

    @Override
    public void enforceProgression(EntityPlayer player, World world) {
        if (!world.field_72995_K && player.field_70173_aa % 60 == 0) {
            player.func_70690_d(new PotionEffect(TFPotions.frosty, 100, 3));
        }
        this.trySpawnHintMonster(player, world);
    }

    @Override
    protected TFFeature getContainedFeature() {
        return TFFeature.ICE_TOWER;
    }
}

