/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks;

import com.bafomdad.uniquecrops.blocks.BlockBaseUC;
import com.bafomdad.uniquecrops.dimension.CropWorldTeleporter;
import com.bafomdad.uniquecrops.init.UCDimension;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCropPortal
extends BlockBaseUC {
    protected static final AxisAlignedBB PORTAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    private static final CropWorldTeleporter TP = new CropWorldTeleporter();

    public BlockCropPortal() {
        super("portal", Material.field_151567_E);
        this.func_149711_c(-1.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.75f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PORTAL_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        int dimensionID;
        int n = dimensionID = world.field_73011_w.getDimension() == 0 ? UCDimension.dimID : 0;
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity instanceof EntityPlayer) {
            this.setLastTeleportPosition(world, pos, entity);
            entity.changeDimension(dimensionID, (ITeleporter)TP);
        }
    }

    private void setLastTeleportPosition(World world, BlockPos pos, Entity entity) {
        NBTTagCompound data = entity.getEntityData().func_74775_l("PlayerPersisted");
        if (data != null) {
            NBTTagCompound lastTelePos = new NBTTagCompound();
            int attempts = 5;
            block0: for (EnumFacing facing : EnumFacing.field_176754_o) {
                for (int i = 0; i < attempts; ++i) {
                    BlockPos loopPos = pos.func_177967_a(facing, i);
                    if (world.func_180495_p(loopPos).func_177230_c() == this || !world.func_175623_d(loopPos) && !world.func_175623_d(loopPos.func_177984_a())) continue;
                    pos = loopPos.func_177984_a();
                    continue block0;
                }
            }
            lastTelePos.func_74772_a("UC:LastTeleportPosition", pos.func_177986_g());
            entity.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)lastTelePos);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side != EnumFacing.UP || side != EnumFacing.DOWN) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos loopPos = pos.func_177972_a(facing);
            if (!world.func_175623_d(loopPos)) continue;
            world.func_175698_g(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 2; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            int k = 3369483;
            double d3 = (double)(k >> 16 & 0xFF) / 255.0;
            double d4 = (double)(k >> 8 & 0xFF) / 255.0;
            double d5 = (double)(k >> 0 & 0xFF) / 255.0;
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }
}

