/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks;

import com.bafomdad.uniquecrops.api.ICropBook;
import com.bafomdad.uniquecrops.blocks.tiles.TileSunBlock;
import com.bafomdad.uniquecrops.core.enums.EnumCrops;
import com.bafomdad.uniquecrops.init.UCBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockCropsBase
extends BlockCrops
implements ICropBook {
    private EnumCrops type;
    private boolean extra;
    private boolean clickHarvest;
    private boolean bonemealable;
    private boolean ignoreGrowthRestrictions;

    public BlockCropsBase(EnumCrops type) {
        this.type = type;
        this.extra = true;
        this.clickHarvest = true;
        this.bonemealable = true;
        this.setRegistryName("crop" + type.func_176610_l());
        this.func_149663_c("uniquecrops.crop" + type.func_176610_l());
        UCBlocks.blocks.add((Block)this);
    }

    public String getCropType() {
        return this.type.func_176610_l();
    }

    public boolean canPlantCrop(World world, EntityPlayer player, EnumFacing side, BlockPos pos, ItemStack stack) {
        return true;
    }

    public EnumCrops getType() {
        return this.type;
    }

    public boolean canIgnoreGrowthRestrictions(World world, BlockPos pos) {
        if (!this.ignoreGrowthRestrictions) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos loopPos = pos.func_177972_a(facing);
            TileEntity tile = world.func_175625_s(loopPos);
            if (!(tile instanceof TileSunBlock) || !((TileSunBlock)tile).powered) continue;
            return true;
        }
        return false;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return this.canBonemeal(world, pos);
    }

    public boolean canBonemeal(World world, BlockPos pos) {
        if (this.canIgnoreGrowthRestrictions(world, pos)) {
            return true;
        }
        return this.bonemealable;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.func_185527_x(state) < this.func_185526_g()) {
            return false;
        }
        if (this.clickHarvest) {
            if (this.func_185527_x(state) >= this.func_185526_g() && !world.field_72995_K) {
                world.func_180501_a(pos, this.func_185528_e(0), 3);
                int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
                this.harvestItems(world, pos, state, fortune);
            }
            return true;
        }
        return false;
    }

    private void harvestItems(World world, BlockPos pos, IBlockState state, int fortune) {
        Item item = this.func_149865_P();
        if (item != Items.field_190931_a) {
            int fortuneDrop = fortune > 0 ? world.field_73012_v.nextInt(fortune) : 0;
            for (int i = 0; i < this.func_149745_a(world.field_73012_v) + fortuneDrop; ++i) {
                InventoryHelper.func_180173_a((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.1), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)new ItemStack(item, 1, this.func_180651_a(state)));
            }
        }
        if (this.getCanDropExtra() && world.field_73012_v.nextBoolean()) {
            InventoryHelper.func_180173_a((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.1), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)new ItemStack(this.func_149866_i(), 1, 0));
        }
    }

    public void func_176487_g(World world, BlockPos pos, IBlockState state) {
        if (!this.func_180670_a(world, world.field_73012_v, pos, state)) {
            return;
        }
        super.func_176487_g(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void createParticles(IBlockState state, World world, BlockPos pos, Random rand, EnumParticleTypes particle, int rand2) {
        if (this.func_185527_x(state) >= this.func_185526_g()) {
            double x = pos.func_177958_n();
            double y = (double)pos.func_177956_o() + 0.5;
            double z = pos.func_177952_p();
            if (rand2 > 0) {
                for (int i = 0; i < rand.nextInt(rand2) + 1; ++i) {
                    world.func_175688_a(particle, x + (double)rand.nextFloat(), y, z + (double)rand.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
                }
                return;
            }
            for (int i = 0; i < rand.nextInt(4) + 1; ++i) {
                world.func_175688_a(particle, x + (double)rand.nextFloat(), y, z + (double)rand.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public String getBookDescription() {
        return "uniquecrops.book.page" + this.type.func_176610_l();
    }

    @Override
    public boolean canIncludeInBook() {
        return true;
    }

    public void setBonemealable(boolean flag) {
        this.bonemealable = flag;
    }

    public boolean getCanBonemeal() {
        return this.bonemealable;
    }

    public void setClickHarvest(boolean flag) {
        this.clickHarvest = flag;
    }

    public boolean getCanClickHarvest() {
        return this.clickHarvest;
    }

    public void setExtraDrops(boolean flag) {
        this.extra = flag;
    }

    public boolean getCanDropExtra() {
        return this.extra;
    }

    public void setIgnoreGrowthRestrictions(boolean flag) {
        this.ignoreGrowthRestrictions = flag;
    }

    public boolean ignoresGrowthRestrictions() {
        return this.ignoreGrowthRestrictions;
    }
}

