/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks;

import com.bafomdad.uniquecrops.UniqueCrops;
import com.bafomdad.uniquecrops.blocks.BlockBaseStalk;
import com.bafomdad.uniquecrops.blocks.tiles.TileCraftyPlant;
import com.bafomdad.uniquecrops.core.enums.EnumDirectional;
import com.bafomdad.uniquecrops.init.UCBlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockStalk
extends BlockBaseStalk {
    public static final PropertyEnum STALKS = PropertyEnum.func_177709_a((String)"stalk", EnumDirectional.class);

    public BlockStalk() {
        this.setRegistryName("stalk");
        this.func_149663_c("uniquecrops.stalk");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STALKS, (Comparable)((Object)EnumDirectional.NORTH)));
        this.func_149675_a(true);
        GameRegistry.registerTileEntity(TileCraftyPlant.class, (ResourceLocation)new ResourceLocation("uniquecrops", "craftyplant"));
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.func_176201_c(state) == EnumDirectional.UP.ordinal()) {
            return Item.func_150898_a((Block)Blocks.field_150462_ai);
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCraftyPlant) {
            player.openGui((Object)UniqueCrops.instance, 4, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.func_176201_c(state) == EnumDirectional.DOWN.ordinal() && world.func_175623_d(pos.func_177984_a()) && rand.nextInt(5) == 0) {
            world.func_175718_b(2001, pos.func_177984_a(), Block.func_176210_f((IBlockState)state));
            world.func_180501_a(pos.func_177984_a(), UCBlocks.stalk.func_176223_P().func_177226_a((IProperty)STALKS, (Comparable)((Object)EnumDirectional.UP)), 2);
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.func_176201_c(state) == EnumDirectional.UP.ordinal()) {
            return field_185505_j;
        }
        return field_185506_k;
    }

    @Override
    protected void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (this.func_176201_c(state) == EnumDirectional.DOWN.ordinal()) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos loopPos = pos.func_177972_a(facing);
                if (!world.func_175623_d(loopPos)) continue;
                world.func_175655_b(pos, false);
                return;
            }
        }
        if (this.isNeighborStalkMissing(world, pos, state)) {
            world.func_175655_b(pos, false);
        }
    }

    private boolean isNeighborStalkMissing(World world, BlockPos pos, IBlockState state) {
        if (!(state.func_177230_c() instanceof BlockBaseStalk)) {
            return false;
        }
        EnumDirectional prop = (EnumDirectional)((Object)state.func_177229_b((IProperty)STALKS));
        switch (prop) {
            case NORTH: {
                return this.isStalk(world, pos.func_177974_f()) || this.isStalk(world, pos.func_177976_e());
            }
            case SOUTH: {
                return this.isStalk(world, pos.func_177974_f()) || this.isStalk(world, pos.func_177976_e());
            }
            case WEST: {
                return this.isStalk(world, pos.func_177978_c()) || this.isStalk(world, pos.func_177968_d());
            }
            case EAST: {
                return this.isStalk(world, pos.func_177978_c()) || this.isStalk(world, pos.func_177968_d());
            }
            case NORTHEAST: {
                return this.isStalk(world, pos.func_177968_d()) || this.isStalk(world, pos.func_177976_e());
            }
            case NORTHWEST: {
                return this.isStalk(world, pos.func_177968_d()) || this.isStalk(world, pos.func_177974_f());
            }
            case SOUTHEAST: {
                return this.isStalk(world, pos.func_177978_c()) || this.isStalk(world, pos.func_177976_e());
            }
            case SOUTHWEST: {
                return this.isStalk(world, pos.func_177978_c()) || this.isStalk(world, pos.func_177974_f());
            }
        }
        return false;
    }

    private boolean isStalk(World world, BlockPos pos) {
        return !(world.func_180495_p(pos).func_177230_c() instanceof BlockBaseStalk);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STALKS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STALKS, (Comparable)((Object)EnumDirectional.byIndex(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDirectional)((Object)state.func_177229_b((IProperty)STALKS))).ordinal();
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.func_176201_c(state) == EnumDirectional.UP.ordinal();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCraftyPlant();
    }
}

