/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks.tiles;

import com.bafomdad.uniquecrops.UniqueCropsAPI;
import com.bafomdad.uniquecrops.blocks.tiles.TileBaseRenderUC;
import com.bafomdad.uniquecrops.crafting.SeedRecipe;
import com.bafomdad.uniquecrops.network.PacketUCEffect;
import com.bafomdad.uniquecrops.network.UCPacketHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class TileArtisia
extends TileBaseRenderUC {
    public BlockPos core = BlockPos.field_177992_a;
    private ItemStackHandler inv = new ItemStackHandler(1);
    private static final BlockPos[] GRIDPOS = new BlockPos[]{new BlockPos(-1, 0, -1), new BlockPos(1, 0, 1), new BlockPos(-1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(0, 0, 1)};

    public void findCore() {
        TileEntity te;
        BlockPos looppos;
        int i;
        boolean foundGrid = true;
        for (i = 0; i < GRIDPOS.length; ++i) {
            looppos = this.func_174877_v().func_177971_a((Vec3i)GRIDPOS[i]);
            te = this.func_145831_w().func_175625_s(looppos);
            if (te instanceof TileArtisia) continue;
            foundGrid = false;
            break;
        }
        if (foundGrid) {
            for (i = 0; i < GRIDPOS.length; ++i) {
                looppos = this.func_174877_v().func_177971_a((Vec3i)GRIDPOS[i]);
                te = this.func_145831_w().func_175625_s(looppos);
                if (te == null || !(te instanceof TileArtisia)) continue;
                TileArtisia tile = (TileArtisia)te;
                tile.setCore(this.func_174877_v());
            }
            this.setCore(this.func_174877_v());
        }
    }

    public void setCore(BlockPos pos) {
        this.core = pos;
    }

    public boolean isCore() {
        return this.isValid() && this.core.equals((Object)this.func_174877_v());
    }

    public boolean isValid() {
        return this.core != null && !this.core.equals((Object)BlockPos.field_177992_a);
    }

    public void setStackSpace(EntityItem ei) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < GRIDPOS.length; ++i) {
            BlockPos looppos = this.func_174877_v().func_177971_a((Vec3i)GRIDPOS[i]);
            TileEntity te = this.func_145831_w().func_175625_s(looppos);
            if (!(te instanceof TileArtisia)) continue;
            TileArtisia tile = (TileArtisia)te;
            if (!this.canAccept(this.func_145831_w(), looppos)) continue;
            if (!tile.getItem().func_190926_b()) {
                stacks.add(tile.getItem());
                continue;
            }
            if (!tile.getItem().func_190926_b()) continue;
            ItemStack stack = ei.func_92059_d().func_77946_l();
            stack.func_190920_e(1);
            if (!this.func_145831_w().field_72995_K) {
                tile.setItem(stack);
                stacks.add(stack);
                ei.func_92059_d().func_190918_g(1);
            }
            tile.markBlockForUpdate();
            UCPacketHandler.sendToNearbyPlayers(this.func_145831_w(), looppos, new PacketUCEffect(EnumParticleTypes.EXPLOSION_NORMAL, ei.field_70165_t - 1.0, ei.field_70163_u, ei.field_70161_v - 1.0, 3));
            if (ei.func_92059_d().func_190916_E() > 0) break;
            ei.func_70106_y();
            break;
        }
        if (stacks.size() >= 8 && !ei.field_70128_L) {
            SeedRecipe recipe;
            ItemStack stack = ei.func_92059_d().func_77946_l();
            stack.func_190920_e(1);
            if (!this.func_145831_w().field_72995_K) {
                this.setItem(stack);
                ei.func_92059_d().func_190918_g(1);
                stacks.add(stack);
            }
            if (ei.func_92059_d().func_190916_E() <= 0) {
                ei.func_70106_y();
            }
            if ((recipe = UniqueCropsAPI.SEED_RECIPE_REGISTRY.findRecipe(stacks)) != null && !this.func_145831_w().field_72995_K) {
                ItemStack output = recipe.getOutput().func_77946_l();
                this.clearItems();
                this.setItem(output);
            }
            this.markBlockForUpdate();
        }
    }

    private void clearItems() {
        for (int i = 0; i < GRIDPOS.length; ++i) {
            BlockPos looppos = this.func_174877_v().func_177971_a((Vec3i)GRIDPOS[i]);
            TileEntity te = this.func_145831_w().func_175625_s(looppos);
            if (te == null || !(te instanceof TileArtisia)) continue;
            ((TileArtisia)te).setItem(ItemStack.field_190927_a);
            ((TileArtisia)te).markBlockForUpdate();
            UCPacketHandler.sendToNearbyPlayers(this.func_145831_w(), looppos, new PacketUCEffect(EnumParticleTypes.REDSTONE, looppos.func_177958_n(), (double)looppos.func_177956_o() + 0.5, looppos.func_177952_p(), 6));
        }
        UCPacketHandler.sendToNearbyPlayers(this.func_145831_w(), this.func_174877_v(), new PacketUCEffect(EnumParticleTypes.REDSTONE, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), 6));
    }

    private boolean canAccept(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != null && block instanceof BlockCrops) {
            return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockCrops.field_176488_a) >= ((BlockCrops)block).func_185526_g();
        }
        return false;
    }

    public ItemStack getItem() {
        return this.inv.getStackInSlot(0);
    }

    public void setItem(ItemStack stack) {
        this.inv.setStackInSlot(0, stack);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74772_a("Core", this.core.func_177986_g());
        tag.func_74782_a("inventory", (NBTBase)this.inv.serializeNBT());
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.core = BlockPos.func_177969_a((long)tag.func_74763_f("Core"));
        this.inv.deserializeNBT(tag.func_74775_l("inventory"));
    }
}

