/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks.tiles;

import com.bafomdad.uniquecrops.blocks.tiles.TileBaseUC;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileDigger
extends TileBaseUC {
    BlockPos digPos = BlockPos.field_177992_a;
    boolean jobDone = false;

    public boolean isJobDone() {
        return this.jobDone;
    }

    public boolean digBlock(World digWorld) {
        if (this.digPos == BlockPos.field_177992_a) {
            this.startDig(digWorld);
        }
        if (this.canDig(digWorld)) {
            if (digWorld.func_175625_s(this.digPos) != null) {
                this.advance(digWorld);
                return true;
            }
            IBlockState digState = digWorld.func_180495_p(this.digPos);
            if (this.setQuarriedBlock(digWorld, digState)) {
                this.advance(digWorld);
                return true;
            }
        }
        return false;
    }

    private boolean canDig(World digWorld) {
        if (this.digPos == BlockPos.field_177992_a) {
            return false;
        }
        IBlockState digState = digWorld.func_180495_p(this.digPos);
        if (digState.func_185887_b(digWorld, this.digPos) < 0.0f || digState.func_177230_c() instanceof BlockFarmland || digState.func_177230_c() instanceof BlockCrops) {
            this.advance(digWorld);
            return false;
        }
        ChunkPos cPos = new ChunkPos(this.digPos);
        if (this.digPos.func_177958_n() > cPos.func_180332_e() && this.digPos.func_177952_p() > cPos.func_180330_f()) {
            this.jobDone = true;
            return false;
        }
        return true;
    }

    private boolean setQuarriedBlock(World digWorld, IBlockState digState) {
        IItemHandler inv;
        if (digWorld.func_175623_d(this.func_174877_v().func_177984_a())) {
            digWorld.func_175655_b(this.digPos, false);
            if (!digState.func_185904_a().func_76224_d()) {
                digWorld.func_180501_a(this.func_174877_v().func_177984_a(), digState, 3);
            }
            return true;
        }
        ItemStack digStack = digState.func_177230_c().func_185473_a(digWorld, this.digPos, digState);
        if (digStack.func_190926_b()) {
            return true;
        }
        TileEntity tile = digWorld.func_175625_s(this.func_174877_v().func_177984_a());
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN) && this.insertQuarryItem(inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN), digStack, true)) {
            this.insertQuarryItem(inv, digStack, false);
            digWorld.func_175655_b(this.digPos, false);
            return true;
        }
        return false;
    }

    private void startDig(World digWorld) {
        ChunkPos chunkPos = new ChunkPos(this.func_174877_v());
        this.digPos = new BlockPos(chunkPos.func_180334_c(), this.func_174877_v().func_177956_o(), chunkPos.func_180333_d());
    }

    private void advance(World digWorld) {
        if (this.digPos.func_177956_o() >= 1) {
            this.digPos = this.digPos.func_177977_b();
        }
        if (this.digPos.func_177956_o() < 1) {
            ChunkPos cPos = new ChunkPos(this.digPos);
            if (this.digPos.func_177958_n() < cPos.func_180332_e()) {
                this.digPos = this.digPos.func_177982_a(1, this.func_174877_v().func_177956_o(), 0);
                if (digWorld.func_175623_d(this.digPos)) {
                    this.advance(digWorld);
                }
                return;
            }
            if (this.digPos.func_177952_p() < cPos.func_180330_f()) {
                this.digPos = this.digPos.func_177982_a(-15, this.func_174877_v().func_177956_o(), 1);
                if (digWorld.func_175623_d(this.digPos)) {
                    this.advance(digWorld);
                }
                return;
            }
        }
    }

    private boolean insertQuarryItem(IItemHandler inv, ItemStack stack, boolean simulate) {
        return ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)stack, (boolean)simulate).func_190926_b();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74772_a("UC:digPos", this.digPos.func_177986_g());
        tag.func_74757_a("UC:digJobFinished", this.jobDone);
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.digPos = BlockPos.func_177969_a((long)tag.func_74763_f("UC:digPos"));
        this.jobDone = tag.func_74767_n("UC:digJobFinished");
    }
}

