/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks.tiles;

import com.bafomdad.uniquecrops.blocks.tiles.TileBaseRenderUC;
import com.bafomdad.uniquecrops.core.UCUtils;
import com.bafomdad.uniquecrops.network.PacketUCEffect;
import com.bafomdad.uniquecrops.network.UCPacketHandler;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileExedo
extends TileBaseRenderUC
implements ITickable {
    int searchTime = 100;
    int wiggleTime;
    public int timeAfterWiggle;
    public final int maxTime = 15;
    public boolean isWiggling = false;
    public boolean isChomping = false;
    boolean foundEntity = false;
    private UUID entityId;
    public EntityLivingBase ent;

    public double func_145833_n() {
        return super.func_145833_n() * 1.5;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 3), (double)(this.func_174877_v().func_177956_o() - 3), (double)(this.func_174877_v().func_177952_p() - 3), (double)(this.func_174877_v().func_177958_n() + 3), (double)(this.func_174877_v().func_177956_o() + 3), (double)(this.func_174877_v().func_177952_p() + 3));
    }

    public void func_73660_a() {
        EntityLivingBase elb;
        ++this.timeAfterWiggle;
        if (!this.field_145850_b.field_72995_K && this.isChomping && this.timeAfterWiggle >= 15) {
            this.reset();
        }
        if (this.entityId != null) {
            this.ent = UCUtils.getTaggedEntity(this.field_145850_b, this.field_174879_c, this.entityId, 5);
        }
        if (this.entityId == null && this.ent != null) {
            this.ent = null;
        }
        if (!this.field_145850_b.field_72995_K && this.isWiggling && --this.wiggleTime <= 0) {
            this.isWiggling = false;
            UCPacketHandler.dispatchTEToNearbyPlayers(this);
        }
        if (this.field_145850_b.func_82737_E() % (long)(this.searchTime - this.field_145850_b.field_73012_v.nextInt(20)) == 0L && !this.isWiggling && !this.isChomping && (elb = this.getTargetedEntity()) != null) {
            if (this.foundEntity) {
                this.chomp(elb);
                return;
            }
            this.entityId = elb.getPersistentID();
            this.wiggle();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.isWiggling = tag.func_74767_n("UC:wiggle");
        this.isChomping = tag.func_74767_n("UC:chomp");
        if (tag.func_74764_b("UC:targetEntity")) {
            this.entityId = UUID.fromString(tag.func_74779_i("UC:targetEntity"));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74757_a("UC:wiggle", this.isWiggling);
        tag.func_74757_a("UC:chomp", this.isChomping);
        if (this.entityId != null) {
            tag.func_74778_a("UC:targetEntity", this.entityId.toString());
        } else {
            tag.func_82580_o("UC:targetEntity");
        }
    }

    private void wiggle() {
        this.wiggleTime = 20;
        this.foundEntity = true;
        this.isWiggling = true;
        UCPacketHandler.dispatchTEToNearbyPlayers(this);
    }

    private void chomp(EntityLivingBase elb) {
        this.isChomping = true;
        this.timeAfterWiggle = 0;
        this.foundEntity = false;
        this.func_70296_d();
        UCPacketHandler.dispatchTEToNearbyPlayers(this);
    }

    private void reset() {
        this.isChomping = false;
        this.nomAndDrop();
        this.func_70296_d();
        UCPacketHandler.dispatchTEToNearbyPlayers(this);
    }

    private void nomAndDrop() {
        EntityLivingBase elb = UCUtils.getTaggedEntity(this.field_145850_b, this.field_174879_c, this.entityId, 5);
        if (elb != null && elb.func_70089_S()) {
            elb.func_70097_a(DamageSource.field_76377_j, elb.func_110138_aP());
            UCPacketHandler.sendToNearbyPlayers(this.field_145850_b, this.field_174879_c, new PacketUCEffect(EnumParticleTypes.EXPLOSION_NORMAL, elb.field_70165_t - 1.5, elb.field_70163_u, elb.field_70161_v - 1.5, 20));
            elb.func_70106_y();
        }
        this.entityId = null;
    }

    private EntityLivingBase getTargetedEntity() {
        if (!this.field_145850_b.field_72995_K) {
            List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-5, 0, -5), this.field_174879_c.func_177982_a(5, 2, 5)));
            for (EntityLivingBase elb : entities) {
                if (elb instanceof EntityPlayer || elb.func_180431_b(DamageSource.field_76380_i)) continue;
                this.entityId = elb.getPersistentID();
                return elb;
            }
        }
        return null;
    }
}

