/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks.tiles;

import com.bafomdad.uniquecrops.blocks.tiles.TileBaseUC;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.NBTTagCompound;

public class TileMillennium
extends TileBaseUC {
    private String timestamp;
    private static final String DATEFORMAT = "yyyy-mm-dd hh:mm:ss";

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("UC_timestamp")) {
            this.timestamp = tag.func_74779_i("UC_timestamp");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        if (!this.isTimeEmpty()) {
            tag.func_74778_a("UC_timestamp", this.timestamp);
        }
    }

    public boolean isTimeEmpty() {
        return this.timestamp == null || this.timestamp != null && this.timestamp.isEmpty();
    }

    public void setTime() {
        String dateFormat;
        LocalDateTime ldt = LocalDateTime.now();
        Date date = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        this.timestamp = dateFormat = new SimpleDateFormat(DATEFORMAT).format(date);
    }

    public long calcTime() {
        if (!this.isTimeEmpty()) {
            try {
                long diff = System.currentTimeMillis() - new SimpleDateFormat(DATEFORMAT).parse(this.timestamp).getTime();
                return TimeUnit.MILLISECONDS.toMinutes(diff) % 60L;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }
}

