/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks.tiles;

import com.bafomdad.uniquecrops.blocks.tiles.TileBaseUC;
import com.bafomdad.uniquecrops.crops.Musica;
import com.bafomdad.uniquecrops.init.UCBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraftforge.event.world.NoteBlockEvent;

public class TileMusicaPlant
extends TileBaseUC
implements ITickable {
    private List<Beat> beats = new ArrayList<Beat>();
    private long lastBeat = 0L;
    private int musicStrength;

    public void func_73660_a() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state == null || state != null && state.func_177230_c() != UCBlocks.cropMusica) {
            return;
        }
        if (this.func_145838_q() != null && ((Musica)this.func_145838_q()).func_185525_y(state)) {
            return;
        }
        if (this.field_145850_b.field_72995_K || this.beats.isEmpty() || this.beats.size() == 0) {
            return;
        }
        for (int i = 0; i < this.beats.size(); ++i) {
            Beat beat = this.beats.get(i);
            this.listenAndRemove(beat, i);
            ArrayList<Integer> timelist = new ArrayList<Integer>();
            int elapsedtime = (int)beat.getTimeElapsed(this.field_145850_b.func_82737_E(), beat.getTime());
            if (beat.getTime() != this.lastBeat && elapsedtime % 2 == 0) {
                timelist.add(elapsedtime);
            }
            if (timelist.isEmpty() || this.beats.isEmpty() || this.field_145850_b.func_82737_E() % 10L != 0L || this.lastBeat <= 0L) continue;
            int randomtick = this.field_145850_b.field_73012_v.nextInt(100) + 5 - timelist.size();
            if (this.getPercussion() == null || (long)randomtick >= this.getPercussion().getTimeElapsed(this.field_145850_b.func_82737_E(), this.lastBeat)) continue;
            ((Musica)this.field_145854_h).addAge(this.field_145850_b, this.func_174877_v(), state, 1);
            return;
        }
        if (this.lastBeat == 0L && this.getPercussion() != null) {
            this.lastBeat = this.getPercussion().getTime();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        NBTTagList taglist = tag.func_150295_c("UC_tagBeatlist", 10);
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound tag2 = taglist.func_150305_b(i);
            NoteBlockEvent.Note tagnote = NoteBlockEvent.Note.values()[tag2.func_74762_e("UC_tagNote")];
            NoteBlockEvent.Instrument taginst = NoteBlockEvent.Instrument.values()[tag2.func_74762_e("UC_tagInstrument")];
            NoteBlockEvent.Octave tagoct = NoteBlockEvent.Octave.values()[tag2.func_74762_e("UC_tagOctave")];
            long tagtime = tag2.func_74763_f("UC_tagWorldtime");
            this.setNote(tagnote, taginst, tagoct, tagtime);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        if (!this.beats.isEmpty() || this.beats.size() > 0) {
            NBTTagList taglist = new NBTTagList();
            for (int i = 0; i < this.beats.size(); ++i) {
                Beat beat = this.beats.get(i);
                NBTTagCompound tag2 = new NBTTagCompound();
                tag2.func_74768_a("UC_tagNote", beat.note);
                tag2.func_74768_a("UC_tagInstrument", beat.instrument);
                tag2.func_74768_a("UC_tagOctave", beat.octave);
                tag2.func_74772_a("UC_tagWorldtime", beat.worldtime);
                taglist.func_74742_a((NBTBase)tag2);
            }
            tag.func_74782_a("UC_tagBeatlist", (NBTBase)taglist);
        }
    }

    public List<Beat> getBeats() {
        return this.beats;
    }

    public boolean canAddNote() {
        return this.beats.size() < 12;
    }

    public Beat setNote(NoteBlockEvent.Note note, NoteBlockEvent.Instrument instrument, NoteBlockEvent.Octave octave, long time) {
        Beat beat = new Beat(note, instrument, octave, time);
        this.beats.add(beat);
        return beat;
    }

    public Beat setNewBeatTime(int index, long newtime) {
        Beat beat = this.beats.get(index);
        beat.worldtime = newtime;
        return beat;
    }

    public void clearBeats() {
        this.beats.clear();
    }

    public void listenAndRemove(Beat beat, int index) {
        long diff = beat.getTimeElapsed(this.field_145850_b.func_82737_E(), beat.getTime());
        if (diff > 50L) {
            if (beat.getTime() == this.lastBeat) {
                this.lastBeat = 0L;
            }
            this.beats.remove(index);
        }
    }

    public boolean isPercussion(NoteBlockEvent.Instrument instrument) {
        return instrument == NoteBlockEvent.Instrument.SNARE || instrument == NoteBlockEvent.Instrument.BASSDRUM;
    }

    public Beat getPercussion() {
        for (Beat beat : this.beats) {
            if (!this.isPercussion(beat.getInstrument())) continue;
            return beat;
        }
        return null;
    }

    public static enum BPM {
        EMPTY(0, 0),
        LARGO(40, 60),
        ADAGIO(66, 76),
        MODERATO(108, 120),
        PRESTO(168, 200);

        int minRange;
        int maxRange;

        private BPM(int min, int max) {
            this.minRange = min;
            this.maxRange = max;
        }

        public static BPM getType(int time) {
            for (BPM e : BPM.values()) {
                if (!BPM.matches(e, time)) continue;
                return e;
            }
            return EMPTY;
        }

        private static boolean matches(BPM bpm, int time) {
            return bpm.minRange < time && time > bpm.maxRange;
        }
    }

    public static class Beat {
        int note;
        int instrument;
        int octave;
        long worldtime;

        public Beat(NoteBlockEvent.Note note, NoteBlockEvent.Instrument instrument, NoteBlockEvent.Octave octave, long worldtime) {
            this.note = note.ordinal();
            this.instrument = instrument.ordinal();
            this.octave = octave.ordinal();
            this.worldtime = worldtime;
        }

        public NoteBlockEvent.Note getNote() {
            return NoteBlockEvent.Note.values()[this.note];
        }

        public NoteBlockEvent.Instrument getInstrument() {
            return NoteBlockEvent.Instrument.values()[this.instrument];
        }

        public NoteBlockEvent.Octave getOctave() {
            return NoteBlockEvent.Octave.values()[this.octave];
        }

        public long getTime() {
            return this.worldtime;
        }

        public long getTimeElapsed(long newtime, long oldtime) {
            if (newtime < oldtime) {
                return oldtime - newtime;
            }
            return newtime - oldtime;
        }

        public boolean beatMatches(Beat newbeat) {
            return this.getNote().equals((Object)newbeat.getNote()) && this.getInstrument().equals((Object)newbeat.getInstrument()) && this.getOctave().equals((Object)newbeat.getOctave());
        }

        public String toString() {
            return "[Note: " + this.getNote() + " / Instrument: " + this.getInstrument() + " / Octave: " + this.getOctave() + " / Time: " + this.getTime() + "]";
        }
    }
}

