/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.core;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import java.awt.Point;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@JsonAdapter(value=Deserializer.class)
public class MultiblockPattern {
    public static final MultiblockPattern DEFAULT = new MultiblockPattern(new ItemStack(Items.field_151045_i), 0, new String[]{"OQO", "QGQ", "OQO"}, new String[]{"RRR", "RAR", "RRR"}, new Point(1, 1), (Map<Character, Slot>)new HashMap<Character, Slot>(){
        {
            this.put(Character.valueOf('O'), new Slot(Blocks.field_150343_Z));
            this.put(Character.valueOf('Q'), new Slot(Blocks.field_150464_aj.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(7))));
            this.put(Character.valueOf('G'), new Slot(Blocks.field_150426_aN));
        }
    }, (Map<Character, Slot>)new HashMap<Character, Slot>(){
        {
            this.put(Character.valueOf('R'), new Slot(Blocks.field_150448_aq));
            this.put(Character.valueOf('A'), new Slot(Blocks.field_180405_aT));
        }
    }, "Example Pattern", "do.not.bother.translating.this");
    private final ItemStack catalyst;
    private final String[] shape;
    private final Point origin;
    private final Map<Character, Slot> definition;
    private final int power;
    private final String[] shapeResult;
    private final Map<Character, Slot> definitionResult;
    private String name;
    private String description;

    public MultiblockPattern(ItemStack catalyst, int power, String[] shape, String[] shapeResult, Point origin, Map<Character, Slot> definition, Map<Character, Slot> definitionResult, String patternName, String description) {
        this.catalyst = catalyst;
        this.power = power;
        this.shape = shape;
        this.shapeResult = shapeResult;
        this.origin = origin;
        this.definition = definition;
        this.definition.put(Character.valueOf(' '), new Slot(Blocks.field_150350_a.func_176223_P()));
        this.definitionResult = definitionResult;
        this.definitionResult.put(Character.valueOf(' '), new Slot(Blocks.field_150350_a.func_176223_P()));
        char originChar = shape[origin.y].charAt(origin.x);
        if (originChar == ' ' || definition.get(Character.valueOf(originChar)).test(Blocks.field_150350_a.func_176223_P())) {
            throw new IllegalStateException(patternName + ": Origin point cannot be blank space");
        }
        int lineLength = shape[0].length();
        for (String line : shape) {
            if (line.length() != lineLength) {
                throw new IllegalStateException(patternName + ": All lines in the shape must be the same size");
            }
            for (char letter : line.toCharArray()) {
                if (definition.get(Character.valueOf(letter)) != null) continue;
                throw new IllegalStateException(patternName + ": " + letter + " is not defined.");
            }
        }
        for (String line2 : shapeResult) {
            if (line2.length() != lineLength) {
                throw new IllegalStateException(patternName + ": All lines in the shape must be the same size");
            }
            for (char letter : line2.toCharArray()) {
                if (definitionResult.get(Character.valueOf(letter)) != null) continue;
                throw new IllegalStateException(patternName + ": " + letter + " is not defined.");
            }
        }
        this.name = patternName;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    public int getPower() {
        return this.power;
    }

    public String[] getShape() {
        return this.shape;
    }

    public String[] getShapeResult() {
        return this.shapeResult;
    }

    public Map<Character, Slot> getDefinition() {
        return this.definition;
    }

    public Map<Character, Slot> getDefinitionResult() {
        return this.definitionResult;
    }

    public ActionResult<Set<BlockPos>> match(World world, BlockPos originBlock) {
        HashSet matched = Sets.newHashSet();
        for (int y = 0; y < this.shape.length; ++y) {
            String line = this.shape[y];
            for (int x = 0; x < line.length(); ++x) {
                BlockPos offset = originBlock.func_177982_a(x - this.origin.x, 0, y - this.origin.y);
                IBlockState state = world.func_180495_p(offset);
                if (!this.definition.get(Character.valueOf(line.charAt(x))).test(state)) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, Collections.emptySet());
                }
                matched.add(offset);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)matched);
    }

    public void setResult(World world, BlockPos originBlock) {
        for (int y = 0; y < this.shapeResult.length; ++y) {
            String line = this.shapeResult[y];
            for (int x = 0; x < line.length(); ++x) {
                BlockPos offset = originBlock.func_177982_a(x - this.origin.x, 0, y - this.origin.y);
                IBlockState state = this.definitionResult.get(Character.valueOf(line.charAt(x))).getFirstState();
                world.func_175718_b(2001, offset, Block.func_176210_f((IBlockState)state));
                world.func_180501_a(offset, state, 2);
            }
        }
    }

    public boolean isOriginBlock(IBlockState state) {
        Slot slot = this.definition.get(Character.valueOf(this.shape[this.origin.y].charAt(this.origin.x)));
        return slot.test(state);
    }

    public Block getOriginBlock(IBlockState state, Map<Character, Slot> definition, String[] shape) {
        Slot slot = definition.get(Character.valueOf(shape[this.origin.y].charAt(this.origin.x)));
        return slot.test(state) ? slot.getFirstState().func_177230_c() : Blocks.field_150350_a;
    }

    public static class SerializerBlockState
    implements JsonDeserializer<Set<IBlockState>> {
        public Set<IBlockState> deserialize(JsonElement element, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            HashSet states = Sets.newHashSet();
            for (JsonElement entry : element.getAsJsonArray()) {
                String state = entry.getAsJsonPrimitive().getAsString();
                if (state.contains("[")) {
                    String[] stateValues;
                    String[] split = state.split("\\[");
                    split[1] = split[1].substring(0, split[1].lastIndexOf("]"));
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0]));
                    if (block == Blocks.field_150350_a) {
                        return Collections.singleton(block.func_176223_P());
                    }
                    BlockStateContainer blockState = block.func_176194_O();
                    IBlockState returnState = blockState.func_177621_b();
                    for (String value : stateValues = split[1].split(",")) {
                        String[] valueSplit = value.split("=");
                        IProperty property = blockState.func_185920_a(valueSplit[0]);
                        if (property == null) continue;
                        returnState = returnState.func_177226_a(property, (Comparable)property.func_185929_b(valueSplit[1]).get());
                    }
                    states.add(returnState);
                    continue;
                }
                states.addAll(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(state))).func_176194_O().func_177619_a());
            }
            return states;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<MultiblockPattern> {
        public MultiblockPattern deserialize(JsonElement element, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            ResourceLocation itemId = new ResourceLocation(json.getAsJsonObject("catalyst").getAsJsonPrimitive("item").getAsString());
            int meta = json.getAsJsonObject("catalyst").getAsJsonPrimitive("data").getAsInt();
            int power = json.getAsJsonObject("catalyst").getAsJsonPrimitive("power").getAsInt();
            ItemStack catalyst = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(itemId), 1, meta);
            String[] shape = (String[])ctx.deserialize((JsonElement)json.getAsJsonArray("shape"), String[].class);
            String[] shapeResult = (String[])ctx.deserialize((JsonElement)json.getAsJsonArray("shaperesult"), String[].class);
            Point origin = (Point)ctx.deserialize((JsonElement)json.getAsJsonObject("origin"), Point.class);
            Map definition = (Map)ctx.deserialize((JsonElement)json.getAsJsonObject("definition"), new TypeToken<Map<Character, Slot>>(){}.getType());
            Map definitionResult = (Map)ctx.deserialize((JsonElement)json.getAsJsonObject("definitionresult"), new TypeToken<Map<Character, Slot>>(){}.getType());
            String patternName = json.getAsJsonPrimitive("name").getAsString();
            String description = json.getAsJsonPrimitive("description").getAsString();
            return new MultiblockPattern(catalyst, power, shape, shapeResult, origin, definition, definitionResult, patternName, description);
        }
    }

    public static class Slot
    implements Predicate<IBlockState> {
        @JsonAdapter(value=SerializerBlockState.class)
        private final Set<IBlockState> states;

        public Slot(IBlockState ... states) {
            this.states = Sets.newHashSet((Object[])states);
        }

        public Slot(Block block) {
            this((IBlockState[])block.func_176194_O().func_177619_a().toArray((Object[])new IBlockState[0]));
        }

        @Override
        public boolean test(IBlockState state) {
            return this.states.contains(state);
        }

        public IBlockState getFirstState() {
            Iterator<IBlockState> iter = this.states.iterator();
            return iter.next();
        }
    }
}

