/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.core.enums;

import com.bafomdad.uniquecrops.blocks.tiles.TileFeroxia;
import com.bafomdad.uniquecrops.core.UCConfig;
import com.bafomdad.uniquecrops.core.UCUtils;
import com.bafomdad.uniquecrops.init.UCBlocks;
import com.bafomdad.uniquecrops.init.UCItems;
import com.bafomdad.uniquecrops.network.PacketUCEffect;
import com.bafomdad.uniquecrops.network.UCPacketHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public enum EnumGrowthSteps {
    MOONPHASE("uniquecrops.condition.fullmoon", UCConfig.GrowthConfig.moonPhase){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            return world.func_130001_d() == 1.0f;
        }
    }
    ,
    HASTORCH("uniquecrops.condition.hastorch", UCConfig.GrowthConfig.hasTorch){
        int range = 10;

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            if (this.getTile(world, pos) == null) {
                return false;
            }
            List players = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos.func_177982_a(-this.range, -this.range, -this.range), pos.func_177982_a(this.range, this.range, this.range)));
            for (EntityPlayer player : players) {
                if (!player.func_110124_au().equals(this.getTile(world, pos).getOwner())) continue;
                ItemStack hand = player.func_184614_ca();
                ItemStack offhand = player.func_184592_cb();
                if ((hand.func_190926_b() || hand.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150478_aa)) && (offhand.func_190926_b() || offhand.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150478_aa))) continue;
                return true;
            }
            return false;
        }
    }
    ,
    LIKESDARKNESS("uniquecrops.condition.darkness", UCConfig.GrowthConfig.likesDarkness){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            return world.func_175671_l(pos.func_177984_a()) < 3 && world.func_175623_d(pos.func_177984_a());
        }
    }
    ,
    DRYFARMLAND("uniquecrops.condition.dryfarmland", UCConfig.GrowthConfig.dryFarmland){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            return world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak && (Integer)world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)BlockFarmland.field_176531_a) < 7;
        }
    }
    ,
    UNDERFARMLAND("uniquecrops.condition.underfarmland", UCConfig.GrowthConfig.underFarmland){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            return world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150458_ak;
        }
    }
    ,
    BURNINGPLAYER("uniquecrops.condition.burningplayer", UCConfig.GrowthConfig.burningPlayer){
        int range = 10;

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            if (this.getTile(world, pos) == null) {
                return false;
            }
            List players = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos.func_177982_a(-this.range, -this.range, -this.range), pos.func_177982_a(this.range, this.range, this.range)));
            for (EntityPlayer player : players) {
                if (!player.func_110124_au().equals(this.getTile(world, pos).getOwner()) || !player.func_70027_ad() || player.func_70045_F()) continue;
                return true;
            }
            return false;
        }
    }
    ,
    HELLWORLD("uniquecrops.condition.hellworld", UCConfig.GrowthConfig.hellWorld){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            return world.field_73011_w.getDimension() == -1;
        }
    }
    ,
    LIKESHEIGHTS("uniquecrops.condition.likesheights", UCConfig.GrowthConfig.likesHeights){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            return pos.func_177956_o() > 100;
        }
    }
    ,
    LIKESLILYPADS("uniquecrops.condition.likeslilypads", UCConfig.GrowthConfig.likesLilypads){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            int lilypads = 0;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                Block lilypad = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
                if (lilypad == null || lilypad != Blocks.field_150392_bi && lilypad != UCBlocks.lavaLily) continue;
                ++lilypads;
            }
            return lilypads >= 4;
        }
    }
    ,
    THIRSTYPLANT("uniquecrops.condition.thirstyplant", UCConfig.GrowthConfig.thirstyPlant){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)));
            for (EntityItem item : items) {
                if (item.field_70128_L || item.func_92059_d().func_190926_b() || item.func_92059_d().func_77973_b() != Items.field_151131_as) continue;
                UCPacketHandler.sendToNearbyPlayers(world, pos, new PacketUCEffect(EnumParticleTypes.WATER_DROP, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 6));
                item.func_92058_a(new ItemStack(Items.field_151133_ar, 1, 0));
                return true;
            }
            return false;
        }
    }
    ,
    HUNGRYPLANT("uniquecrops.condition.hungryplant", UCConfig.GrowthConfig.hungryPlant){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)));
            for (EntityItem item : items) {
                if (item.field_70128_L || item.func_92059_d().func_190926_b() || !(item.func_92059_d().func_77973_b() instanceof ItemFood)) continue;
                UCPacketHandler.sendToNearbyPlayers(world, pos, new PacketUCEffect(EnumParticleTypes.CLOUD, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 6));
                item.func_92059_d().func_190918_g(1);
                if (item.func_92059_d().func_190916_E() <= 0) {
                    item.func_70106_y();
                }
                return true;
            }
            return false;
        }
    }
    ,
    LIKESCHICKEN("uniquecrops.condition.likeschicken", UCConfig.GrowthConfig.likesChicken){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            Entity item = null;
            Entity chicken = null;
            List entities = world.func_72872_a(Entity.class, new AxisAlignedBB(pos.func_177982_a(-3, 0, -3), pos.func_177982_a(3, 1, 3)));
            for (Entity ent : entities) {
                if (ent.field_70128_L) continue;
                if (ent instanceof EntityChicken) {
                    chicken = ent;
                }
                if (ent instanceof EntityItem && ((EntityItem)ent).func_92059_d().func_77973_b() == Items.field_151054_z) {
                    item = ent;
                }
                if (item == null || chicken == null) continue;
                break;
            }
            if (chicken != null && item != null) {
                AxisAlignedBB aabb = new AxisAlignedBB(chicken.func_180425_c().func_177982_a(0, 0, 0), chicken.func_180425_c().func_177982_a(1, 1, 1));
                List list = world.func_72839_b(chicken, aabb);
                for (Entity entity : list) {
                    if (entity == null || entity != item) continue;
                    EntityItem ei = new EntityItem(item.field_70170_p, item.field_70165_t, item.field_70163_u, item.field_70161_v, new ItemStack(UCItems.teriyaki));
                    ((EntityItem)item).func_92059_d().func_190918_g(1);
                    if (((EntityItem)item).func_92059_d().func_190916_E() <= 0) {
                        item.func_70106_y();
                    }
                    chicken.func_70106_y();
                    UCPacketHandler.sendToNearbyPlayers(world, pos, new PacketUCEffect(EnumParticleTypes.EXPLOSION_NORMAL, chicken.field_70165_t, chicken.field_70163_u + 0.5, chicken.field_70161_v, 3));
                    if (!world.field_72995_K) {
                        world.func_72838_d((Entity)ei);
                    }
                    return true;
                }
            } else if (chicken != null) {
                UCPacketHandler.sendToNearbyPlayers(world, pos, new PacketUCEffect(EnumParticleTypes.HEART, chicken.field_70165_t, chicken.field_70163_u + 1.0, chicken.field_70161_v, 3));
                return true;
            }
            return false;
        }
    }
    ,
    REQUIRESREDSTONE("uniquecrops.condition.redstone", UCConfig.GrowthConfig.likesRedstone){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                int powersignal = world.func_175651_c(pos.func_177972_a(facing), facing);
                if (powersignal < 8) continue;
                return true;
            }
            return false;
        }
    }
    ,
    VAMPIREPLANT("uniquecrops.condition.vampire", UCConfig.GrowthConfig.vampirePlant){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            int sunlight = world.func_175642_b(EnumSkyBlock.SKY, pos);
            return sunlight == 0;
        }
    }
    ,
    FULLBRIGHTNESS("uniquecrops.condition.fullbrightness", UCConfig.GrowthConfig.fullBrightness){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            int light = world.func_175642_b(EnumSkyBlock.BLOCK, pos.func_177984_a());
            return light >= 13;
        }
    }
    ,
    LIKESWARTS("uniquecrops.condition.likeswarts", UCConfig.GrowthConfig.likesWarts){
        int range = 1;

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            int warts = 0;
            Iterable poslist = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-this.range, 0, -this.range), (BlockPos)pos.func_177982_a(this.range, 0, this.range));
            for (BlockPos looppos : poslist) {
                if (world.func_175623_d(looppos) || world.func_180495_p(looppos).func_177230_c() != Blocks.field_150388_bm) continue;
                ++warts;
            }
            return warts == 8;
        }
    }
    ,
    LIKESCOOKING("uniquecrops.condition.likescooking", UCConfig.GrowthConfig.likesCooking){
        int range = 6;

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            Iterable poslist = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-this.range, -2, -this.range), (BlockPos)pos.func_177982_a(this.range, 2, this.range));
            for (BlockPos posit : poslist) {
                TileEntity tile = world.func_175625_s(posit);
                if (!(tile instanceof TileEntityFurnace)) continue;
                return ((TileEntityFurnace)tile).func_174887_a_(2) > 0;
            }
            return false;
        }
    }
    ,
    LIKESBREWING("uniquecrops.condition.likesbrewing", UCConfig.GrowthConfig.likesBrewing){
        int range = 6;

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            Iterable poslist = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-this.range, -2, -this.range), (BlockPos)pos.func_177982_a(this.range, 2, this.range));
            for (BlockPos posit : poslist) {
                TileEntity tile = world.func_175625_s(posit);
                if (!(tile instanceof TileEntityBrewingStand)) continue;
                return ((TileEntityBrewingStand)tile).func_174887_a_(0) > 0;
            }
            return false;
        }
    }
    ,
    CHECKERBOARD("uniquecrops.condition.likescheckers", UCConfig.GrowthConfig.likesCheckers){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            BlockPos[] neighbors = new BlockPos[]{pos.func_177982_a(1, 0, 1), pos.func_177982_a(-1, 0, -1), pos.func_177982_a(1, 0, -1), pos.func_177982_a(-1, 0, 1)};
            BlockPos[] noneighbors = new BlockPos[]{pos.func_177972_a(EnumFacing.EAST), pos.func_177972_a(EnumFacing.NORTH), pos.func_177972_a(EnumFacing.SOUTH), pos.func_177972_a(EnumFacing.WEST)};
            int crops = 0;
            for (BlockPos looppos1 : neighbors) {
                if (world.func_180495_p(looppos1).func_177230_c() != UCBlocks.cropFeroxia) continue;
                ++crops;
            }
            for (BlockPos looppos2 : noneighbors) {
                if (world.func_180495_p(looppos2).func_177230_c() != UCBlocks.cropFeroxia) continue;
                --crops;
            }
            return crops == 4;
        }
    }
    ,
    NOBONEMEAL("uniquecrops.condition.dontbonemeal", UCConfig.GrowthConfig.dontBonemeal){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            return true;
        }
    }
    ,
    SELFSACRIFICE("uniquecrops.condition.selfsacrifice", UCConfig.GrowthConfig.selfSacrifice){

        @Override
        public boolean canAdvance(World world, BlockPos pos, IBlockState state) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileFeroxia) {
                TileFeroxia te = (TileFeroxia)tile;
                EntityPlayer player = UCUtils.getPlayerFromUUID(te.getOwner().toString());
                if (!world.field_72995_K && player != null && world.func_152378_a(te.getOwner()) != null) {
                    NBTTagCompound tag = player.getEntityData();
                    if (!tag.func_74764_b("hasSacrificed")) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "The savage plant whispers: \"The time is right to perform a self sacrifice.\""));
                        tag.func_74757_a("hasSacrificed", false);
                        return false;
                    }
                    if (tag.func_74764_b("hasSacrificed") && tag.func_74767_n("hasSacrificed")) {
                        tag.func_82580_o("hasSacrificed");
                        world.func_180501_a(pos, UCBlocks.cropFeroxia.func_185528_e(7), 2);
                        UCUtils.generateSteps(player);
                        return false;
                    }
                }
            }
            return false;
        }
    };

    private final String desc;
    private final boolean enabled;

    private EnumGrowthSteps(String desc, boolean enabled) {
        this.desc = desc;
        this.enabled = enabled;
    }

    public String getDescription() {
        return this.desc;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TileFeroxia getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFeroxia) {
            return (TileFeroxia)tile;
        }
        return null;
    }

    public abstract boolean canAdvance(World var1, BlockPos var2, IBlockState var3);
}

