/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.crafting;

import com.bafomdad.uniquecrops.core.NBTUtils;
import com.bafomdad.uniquecrops.core.enums.EnumItems;
import com.bafomdad.uniquecrops.items.ItemGeneric;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DiscountBookRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    final String name;

    public DiscountBookRecipe(String name) {
        this.name = name;
        this.setRegistryName(new ResourceLocation("uniquecrops", name));
    }

    public boolean func_77569_a(InventoryCrafting ic, World world) {
        boolean foundDiscountBook = false;
        boolean foundItem = false;
        for (int i = 0; i < ic.func_70302_i_(); ++i) {
            ItemStack stack = ic.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == EnumItems.DISCOUNT.createStack().func_77973_b()) {
                foundDiscountBook = true;
                continue;
            }
            if (!(foundItem || NBTUtils.detectNBT(stack) && NBTUtils.getBoolean(stack, ItemGeneric.TAG_DISCOUNT, false) || stack.func_77973_b().hasContainerItem(stack) || !this.isStackValid(stack))) {
                foundItem = true;
                continue;
            }
            return false;
        }
        return foundDiscountBook && foundItem;
    }

    public ItemStack func_77572_b(InventoryCrafting ic) {
        ItemStack item = ItemStack.field_190927_a;
        for (int i = 0; i < ic.func_70302_i_(); ++i) {
            ItemStack stack = ic.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() == EnumItems.DISCOUNT.createStack().func_77973_b()) continue;
            item = stack;
        }
        ItemStack copy = item.func_77946_l();
        NBTUtils.setBoolean(copy, ItemGeneric.TAG_DISCOUNT, true);
        copy.func_190920_e(1);
        return copy;
    }

    public ItemStack func_77571_b() {
        return EnumItems.DISCOUNT.createStack();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting ic) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)ic);
    }

    private boolean isStackValid(ItemStack stack) {
        return stack.func_77973_b().func_77645_m() && !NBTUtils.getBoolean(stack, ItemGeneric.TAG_DISCOUNT, false);
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }
}

